/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.cost.StatsCalculator;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.security.GroupProvider;
import io.trino.sql.NodeUtils;
import io.trino.sql.ParameterUtils;
import io.trino.sql.SqlFormatterUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateMaterializedViewTask
implements DataDefinitionTask<CreateMaterializedView> {
    private final SqlParser sqlParser;
    private final GroupProvider groupProvider;
    private final StatsCalculator statsCalculator;

    @Inject
    public CreateMaterializedViewTask(SqlParser sqlParser, GroupProvider groupProvider, StatsCalculator statsCalculator) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
    }

    @Override
    public String getName() {
        return "CREATE MATERIALIZED VIEW";
    }

    @Override
    public String explain(CreateMaterializedView statement, List<Expression> parameters) {
        return "CREATE MATERIALIZED VIEW " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateMaterializedView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = new Analyzer(session, metadata, this.sqlParser, this.groupProvider, accessControl, Optional.empty(), parameters, parameterLookup, stateMachine.getWarningCollector(), this.statsCalculator).analyze((Statement)statement);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ConnectorMaterializedViewDefinition.Column(field.getName().get(), field.getType().getTypeId())).collect(ImmutableList.toImmutableList());
        String owner = session.getUser();
        CatalogName catalogName = metadata.getCatalogHandle(session, name.getCatalogName()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + name.getCatalogName()));
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
        Map<String, Object> properties = metadata.getMaterializedViewPropertyManager().getProperties(catalogName, name.getCatalogName(), sqlProperties, session, metadata, accessControl, parameterLookup);
        ConnectorMaterializedViewDefinition definition = new ConnectorMaterializedViewDefinition(sql, Optional.empty(), session.getCatalog(), session.getSchema(), columns, statement.getComment(), owner, properties);
        metadata.createMaterializedView(session, name, definition, statement.isReplace(), statement.isNotExists());
        stateMachine.setOutput(analysis.getTarget());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        return Futures.immediateFuture(null);
    }
}

