/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public class CreateRoleTask
implements DataDefinitionTask<CreateRole> {
    @Override
    public String getName() {
        return "CREATE ROLE";
    }

    @Override
    public ListenableFuture<?> execute(CreateRole statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        String role = statement.getName().getValue().toLowerCase(Locale.ENGLISH);
        Optional<TrinoPrincipal> grantor = statement.getGrantor().map(specification -> MetadataUtil.createPrincipal(session, specification));
        accessControl.checkCanCreateRole(session.toSecurityContext(), role, grantor, catalog);
        Set<String> existingRoles = metadata.listRoles(session, catalog);
        if (existingRoles.contains(role)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_ALREADY_EXISTS, (Node)statement, "Role '%s' already exists", role);
        }
        if (grantor.isPresent() && grantor.get().getType() == PrincipalType.ROLE && !existingRoles.contains(grantor.get().getName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", grantor.get().getName());
        }
        metadata.createRole(session, role, grantor, catalog);
        return Futures.immediateFuture(null);
    }
}

