/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.ListenableFuture;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.sql.SqlFormatter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionManager;
import java.util.List;

public interface DataDefinitionTask<T extends Statement> {
    public String getName();

    public ListenableFuture<?> execute(T var1, TransactionManager var2, Metadata var3, AccessControl var4, QueryStateMachine var5, List<Expression> var6, WarningCollector var7);

    default public String explain(T statement, List<Expression> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(SqlFormatter.formatSql(statement));
        if (!parameters.isEmpty()) {
            builder.append("\n").append("Parameters: ").append(parameters);
        }
        return builder.toString();
    }
}

