/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class SetSchemaAuthorizationTask
implements DataDefinitionTask<SetSchemaAuthorization> {
    @Override
    public String getName() {
        return "SET SCHEMA AUTHORIZATION";
    }

    @Override
    public ListenableFuture<?> execute(SetSchemaAuthorization statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        String catalog = MetadataUtil.getSessionCatalog(metadata, session, (Node)statement);
        CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()));
        if (!metadata.schemaExists(session, source)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", source);
        }
        TrinoPrincipal principal = MetadataUtil.createPrincipal(statement.getPrincipal());
        if (principal.getType() == PrincipalType.ROLE && !metadata.listRoles(session, catalog).contains(principal.getName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", principal.getName());
        }
        accessControl.checkCanSetSchemaAuthorization(session.toSecurityContext(), source, principal);
        metadata.setSchemaAuthorization(session, source, principal);
        return Futures.immediateFuture(null);
    }
}

