/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.Statement;
import io.trino.transaction.TransactionManager;
import java.util.List;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public ListenableFuture<?> execute(SetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Object objectValue;
        PropertyMetadata<?> propertyMetadata;
        Session session = stateMachine.getSession();
        QualifiedName propertyName = statement.getName();
        List parts = propertyName.getParts();
        if (parts.size() > 2) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", propertyName);
        }
        if (parts.size() == 1) {
            accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), (String)parts.get(0));
            propertyMetadata = metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName()));
        } else {
            CatalogName catalogName = metadata.getCatalogHandle(stateMachine.getSession(), (String)parts.get(0)).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Catalog '%s' does not exist", parts.get(0)));
            accessControl.checkCanSetCatalogSessionProperty(SecurityContext.of(session), (String)parts.get(0), (String)parts.get(1));
            propertyMetadata = metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(catalogName, (String)parts.get(1)).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName()));
        }
        Type type = propertyMetadata.getSqlType();
        try {
            objectValue = SessionPropertyManager.evaluatePropertyValue(statement.getValue(), type, session, metadata, accessControl, ParameterUtils.parameterExtractor((Statement)statement, parameters));
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unable to set session property '%s' to '%s': %s", propertyName, statement.getValue(), e.getRawMessage()));
        }
        String value = SessionPropertyManager.serializeSessionProperty(type, objectValue);
        try {
            propertyMetadata.decode(objectValue);
        }
        catch (RuntimeException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, e.getMessage(), new Object[0]);
        }
        stateMachine.addSetSessionProperties(propertyName.toString(), value);
        return Futures.immediateFuture(null);
    }
}

