/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum PageCodecMarker {
    COMPRESSED(1),
    ENCRYPTED(2);

    private final int mask;

    private PageCodecMarker(int bit) {
        Preconditions.checkArgument((bit > 0 && bit <= 8 ? 1 : 0) != 0, (String)"PageCodecMarker bit must be between 1 and 8. Found: %s", (int)bit);
        this.mask = 1 << bit - 1;
    }

    public boolean isSet(byte value) {
        return (Byte.toUnsignedInt(value) & this.mask) == this.mask;
    }

    public byte set(byte value) {
        return (byte)(Byte.toUnsignedInt(value) | this.mask);
    }

    public byte unset(byte value) {
        return (byte)(Byte.toUnsignedInt(value) & ~this.mask);
    }

    public static byte none() {
        return 0;
    }

    public static String toSummaryString(byte markers) {
        if (markers == PageCodecMarker.none()) {
            return "NONE";
        }
        return Arrays.stream(PageCodecMarker.values()).filter(marker -> marker.isSet(markers)).map(Enum::name).collect(Collectors.joining(", "));
    }

    public static final class MarkerSet {
        private byte markers;

        private MarkerSet(byte markers) {
            this.markers = markers;
        }

        public void add(PageCodecMarker marker) {
            this.markers = marker.set(this.markers);
        }

        public boolean contains(PageCodecMarker marker) {
            return marker.isSet(this.markers);
        }

        public void remove(PageCodecMarker marker) {
            this.markers = marker.unset(this.markers);
        }

        public byte byteValue() {
            return this.markers;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("markers", (Object)PageCodecMarker.toSummaryString(this.markers)).toString();
        }

        public int hashCode() {
            return this.markers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MarkerSet) {
                return this.markers == ((MarkerSet)o).markers;
            }
            return false;
        }

        public static MarkerSet of(PageCodecMarker marker) {
            return MarkerSet.fromByteValue(marker.set(PageCodecMarker.none()));
        }

        public static MarkerSet fromByteValue(byte markers) {
            return new MarkerSet(markers);
        }

        public static MarkerSet empty() {
            return MarkerSet.fromByteValue(PageCodecMarker.none());
        }
    }
}

