/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.Signature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FunctionMetadata {
    private final FunctionId functionId;
    private final Signature signature;
    private final String actualName;
    private final boolean nullable;
    private final List<FunctionArgumentDefinition> argumentDefinitions;
    private final boolean hidden;
    private final boolean deterministic;
    private final String description;
    private final FunctionKind kind;
    private final boolean deprecated;

    public FunctionMetadata(Signature signature, boolean nullable, List<FunctionArgumentDefinition> argumentDefinitions, boolean hidden, boolean deterministic, String description, FunctionKind kind) {
        this(FunctionId.toFunctionId(signature), signature, signature.getName(), nullable, argumentDefinitions, hidden, deterministic, description, kind, false);
    }

    public FunctionMetadata(Signature signature, String actualName, boolean nullable, List<FunctionArgumentDefinition> argumentDefinitions, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this(FunctionId.toFunctionId(new Signature(actualName, signature.getTypeVariableConstraints(), signature.getLongVariableConstraints(), signature.getReturnType(), signature.getArgumentTypes(), signature.isVariableArity())), signature, actualName, nullable, argumentDefinitions, hidden, deterministic, description, kind, deprecated);
    }

    public FunctionMetadata(FunctionId functionId, Signature signature, String actualName, boolean nullable, List<FunctionArgumentDefinition> argumentDefinitions, boolean hidden, boolean deterministic, String description, FunctionKind kind, boolean deprecated) {
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.actualName = Objects.requireNonNull(actualName, "actualName is null");
        this.nullable = nullable;
        this.argumentDefinitions = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentDefinitions, "argumentDefinitions is null"));
        this.hidden = hidden;
        this.deterministic = deterministic;
        this.description = Objects.requireNonNull(description, "description is null");
        this.kind = Objects.requireNonNull(kind, "kind is null");
        this.deprecated = deprecated;
    }

    public FunctionId getFunctionId() {
        return this.functionId;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public String getActualName() {
        return this.actualName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<FunctionArgumentDefinition> getArgumentDefinitions() {
        return this.argumentDefinitions;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String getDescription() {
        return this.description;
    }

    public FunctionKind getKind() {
        return this.kind;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        return this.signature.toString();
    }
}

