/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogName;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.BoundSignature;
import io.trino.metadata.CatalogManager;
import io.trino.metadata.CatalogMetadata;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionDependencyDeclaration;
import io.trino.metadata.FunctionId;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.FunctionRegistry;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.NewTableLayout;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.ProcedureRegistry;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.Signature;
import io.trino.metadata.SignatureBinder;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayoutResult;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.window.WindowFunctionSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.ArrayBlockEncoding;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.ByteArrayBlockEncoding;
import io.trino.spi.block.DictionaryBlockEncoding;
import io.trino.spi.block.Int128ArrayBlockEncoding;
import io.trino.spi.block.Int96ArrayBlockEncoding;
import io.trino.spi.block.IntArrayBlockEncoding;
import io.trino.spi.block.LazyBlockEncoding;
import io.trino.spi.block.LongArrayBlockEncoding;
import io.trino.spi.block.MapBlockEncoding;
import io.trino.spi.block.RowBlockEncoding;
import io.trino.spi.block.RunLengthBlockEncoding;
import io.trino.spi.block.ShortArrayBlockEncoding;
import io.trino.spi.block.SingleMapBlockEncoding;
import io.trino.spi.block.SingleRowBlockEncoding;
import io.trino.spi.block.VariableWidthBlockEncoding;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNewTableLayout;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableLayoutHandle;
import io.trino.spi.connector.ConnectorTableLayoutResult;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.ConnectorExpressions;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.tree.QualifiedName;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public final class MetadataManager
implements Metadata {
    private final FunctionRegistry functions;
    private final TypeOperators typeOperators;
    private final FunctionResolver functionResolver;
    private final ProcedureRegistry procedures;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TransactionManager transactionManager;
    private final TypeRegistry typeRegistry;
    private final ConcurrentMap<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();
    private final ConcurrentMap<QueryId, QueryCatalogs> catalogsByQueryId = new ConcurrentHashMap<QueryId, QueryCatalogs>();
    private final ResolvedFunction.ResolvedFunctionDecoder functionDecoder;
    private final LoadingCache<OperatorCacheKey, ResolvedFunction> operatorCache;
    private final LoadingCache<CoercionCacheKey, ResolvedFunction> coercionCache;

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager, ColumnPropertyManager columnPropertyManager, AnalyzePropertyManager analyzePropertyManager, TransactionManager transactionManager, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators, NodeVersion nodeVersion) {
        Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.typeRegistry = new TypeRegistry(featuresConfig);
        this.functions = new FunctionRegistry(this::getBlockEncodingSerde, featuresConfig, typeOperators, blockTypeOperators, nodeVersion.getVersion());
        this.functionResolver = new FunctionResolver(this);
        this.procedures = new ProcedureRegistry();
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
        this.analyzePropertyManager = Objects.requireNonNull(analyzePropertyManager, "analyzePropertyManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.addBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ByteArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ShortArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new IntArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LongArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int96ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int128ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new DictionaryBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new MapBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new SingleMapBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new SingleRowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RunLengthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LazyBlockEncoding());
        this.verifyTypes();
        this.functionDecoder = new ResolvedFunction.ResolvedFunctionDecoder(this::getType);
        this.operatorCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(key -> {
            String name = Signature.mangleOperatorName(key.getOperatorType());
            return this.resolveFunction(QualifiedName.of((String)name), TypeSignatureProvider.fromTypes(key.getArgumentTypes()));
        }));
        this.coercionCache = CacheBuilder.newBuilder().maximumSize(1000L).build(CacheLoader.from(key -> {
            String name = Signature.mangleOperatorName(key.getOperatorType());
            Type fromType = key.getFromType();
            Type toType = key.getToType();
            Signature signature = new Signature(name, toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature()));
            return this.resolve(this.functionResolver.resolveCoercion(this.functions.get(QualifiedName.of((String)name)), signature));
        }));
    }

    public static MetadataManager createTestMetadataManager() {
        return MetadataManager.createTestMetadataManager(new FeaturesConfig());
    }

    public static MetadataManager createTestMetadataManager(FeaturesConfig featuresConfig) {
        return MetadataManager.createTestMetadataManager(new CatalogManager(), featuresConfig);
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager) {
        return MetadataManager.createTestMetadataManager(catalogManager, new FeaturesConfig());
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager, FeaturesConfig featuresConfig) {
        return MetadataManager.createTestMetadataManager(InMemoryTransactionManager.createTestTransactionManager(catalogManager), featuresConfig);
    }

    public static MetadataManager createTestMetadataManager(TransactionManager transactionManager, FeaturesConfig featuresConfig) {
        TypeOperators typeOperators = new TypeOperators();
        return new MetadataManager(featuresConfig, new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new MaterializedViewPropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), transactionManager, typeOperators, new BlockTypeOperators(typeOperators), NodeVersion.UNKNOWN);
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogName catalogName) {
        return this.getCatalogMetadata(session, catalogName).getConnectorCapabilities();
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        return this.getOptionalCatalogMetadata(session, catalogName).isPresent();
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, schema.getCatalogName());
        if (catalog.isEmpty()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
        return catalogMetadata.listConnectorIds().stream().map(catalogMetadata::getMetadataFor).anyMatch(metadata -> metadata.schemaExists(connectorSession, schema.getSchemaName()));
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
            for (CatalogName connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                metadata.listSchemaNames(connectorSession).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).forEach(arg_0 -> ((ImmutableSet.Builder)schemaNames).add(arg_0));
            }
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        Objects.requireNonNull(table, "table is null");
        if (table.getCatalogName().isEmpty() || table.getSchemaName().isEmpty() || table.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        return this.getOptionalCatalogMetadata(session, table.getCatalogName()).flatMap(catalogMetadata -> {
            CatalogName catalogName = catalogMetadata.getConnectorId(session, table);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return Optional.ofNullable(metadata.getTableHandle(connectorSession, table.asSchemaTableName())).map(connectorTableHandle -> new TableHandle(catalogName, (ConnectorTableHandle)connectorTableHandle, catalogMetadata.getTransactionHandleFor(catalogName), Optional.empty()));
        });
    }

    @Override
    public Optional<TableHandle> getTableHandleForStatisticsCollection(Session session, QualifiedObjectName table, Map<String, Object> analyzeProperties) {
        CatalogName catalogName;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(catalogName = catalogMetadata.getConnectorId(session, table))).getTableHandleForStatisticsCollection(session.toConnectorSession(catalogName), table.asSchemaTableName(), analyzeProperties)) != null) {
            return Optional.of(new TableHandle(catalogName, tableHandle, catalogMetadata.getTransactionHandleFor(catalogName), Optional.empty()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getCatalogName();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            return metadata.getSystemTable(session.toConnectorSession(catalogName), tableName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public Optional<TableLayoutResult> getLayout(Session session, TableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        if (constraint.getSummary().isNone()) {
            return Optional.empty();
        }
        CatalogName catalogName = table.getCatalogName();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        Preconditions.checkState((boolean)metadata.usesLegacyTableLayouts(), (Object)"getLayout() was called even though connector doesn't support legacy Table Layout");
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        List layouts = metadata.getTableLayouts(connectorSession, connectorTable, constraint, desiredColumns);
        if (layouts.isEmpty()) {
            return Optional.empty();
        }
        if (layouts.size() > 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Connector returned multiple layouts for table %s", table));
        }
        ConnectorTableLayout tableLayout = ((ConnectorTableLayoutResult)layouts.get(0)).getTableLayout();
        return Optional.of(new TableLayoutResult(new TableHandle(catalogName, connectorTable, transaction, Optional.of(tableLayout.getHandle())), new TableProperties(catalogName, transaction, new ConnectorTableProperties(tableLayout)), (TupleDomain<ColumnHandle>)((ConnectorTableLayoutResult)layouts.get(0)).getUnenforcedConstraint()));
    }

    @Override
    public TableProperties getTableProperties(Session session, TableHandle handle) {
        CatalogName catalogName = handle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return handle.getLayout().map(layout -> new TableProperties(catalogName, handle.getTransaction(), new ConnectorTableProperties(metadata.getTableLayout(connectorSession, layout)))).orElseGet(() -> this.getLayout(session, handle, Constraint.alwaysTrue(), Optional.empty()).get().getTableProperties());
        }
        return new TableProperties(catalogName, handle.getTransaction(), metadata.getTableProperties(connectorSession, handle.getConnectorHandle()));
    }

    @Override
    public TableHandle makeCompatiblePartitioning(Session session, TableHandle tableHandle, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((boolean)partitioningHandle.getConnectorId().isPresent(), (Object)"Expect partitioning handle from connector, got system partitioning handle");
        CatalogName catalogName = partitioningHandle.getConnectorId().get();
        Preconditions.checkArgument((boolean)catalogName.equals(tableHandle.getCatalogName()), (Object)"ConnectorId of tableHandle and partitioningHandle does not match");
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            ConnectorTableLayoutHandle newTableLayoutHandle = metadata.makeCompatiblePartitioning(session.toConnectorSession(catalogName), tableHandle.getLayout().get(), partitioningHandle.getConnectorHandle());
            return new TableHandle(catalogName, tableHandle.getConnectorHandle(), transaction, Optional.of(newTableLayoutHandle));
        }
        Verify.verify((boolean)tableHandle.getLayout().isEmpty(), (String)"layout should not be present", (Object[])new Object[0]);
        ConnectorTableHandle newTableHandle = metadata.makeCompatiblePartitioning(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), partitioningHandle.getConnectorHandle());
        return new TableHandle(catalogName, newTableHandle, transaction, Optional.empty());
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Optional<CatalogName> leftConnectorId = left.getConnectorId();
        Optional<CatalogName> rightConnectorId = right.getConnectorId();
        if (leftConnectorId.isEmpty() || rightConnectorId.isEmpty() || !leftConnectorId.equals(rightConnectorId)) {
            return Optional.empty();
        }
        if (!left.getTransactionHandle().equals(right.getTransactionHandle())) {
            return Optional.empty();
        }
        CatalogName catalogName = leftConnectorId.get();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        Optional commonHandle = metadata.getCommonPartitioningHandle(session.toConnectorSession(catalogName), left.getConnectorHandle(), right.getConnectorHandle());
        return commonHandle.map(handle -> new PartitioningHandle(Optional.of(catalogName), left.getTransactionHandle(), (ConnectorPartitioningHandle)handle));
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        CatalogName catalogName = handle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (this.usesLegacyTableLayouts(session, handle)) {
            ConnectorTableLayoutHandle layoutHandle = handle.getLayout().orElseGet(() -> this.getLayout(session, handle, Constraint.alwaysTrue(), Optional.empty()).get().getNewTableHandle().getLayout().get());
            return metadata.getInfo(layoutHandle);
        }
        return metadata.getInfo(handle.getConnectorHandle());
    }

    @Override
    public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorTableSchema tableSchema = metadata.getTableSchema(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableSchema(catalogName, tableSchema);
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableMetadata(catalogName, tableMetadata);
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle, Constraint constraint) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        TableStatistics tableStatistics = metadata.getTableStatistics(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), constraint);
        Verify.verifyNotNull((Object)tableStatistics, (String)"%s returned null tableStatistics for %s", (Object[])new Object[]{metadata, tableHandle});
        return tableStatistics;
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), (Object)((ColumnHandle)mapEntry.getValue()));
        }
        return map.build();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getColumnMetadata(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            if (this.isExistingRelation(session, objectName.get())) {
                return ImmutableList.of((Object)objectName.get());
            }
            return ImmutableList.of();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet tables = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listTables(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(tables::add);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    private boolean isExistingRelation(Session session, QualifiedObjectName name) {
        if (this.getTableHandle(session, name).isPresent()) {
            return true;
        }
        return this.getView(session, name).isPresent();
    }

    @Override
    public Map<QualifiedObjectName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        HashMap tableColumns = new HashMap();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                    QualifiedObjectName tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    tableColumns.put(tableName, (List)entry.getValue());
                }
                for (Map.Entry<Object, Object> entry : this.getViews(session, prefix).entrySet()) {
                    ImmutableList.Builder columns = ImmutableList.builder();
                    for (ConnectorViewDefinition.ViewColumn column : ((ConnectorViewDefinition)entry.getValue()).getColumns()) {
                        try {
                            columns.add((Object)new ColumnMetadata(column.getName(), this.getType(column.getType())));
                        }
                        catch (TypeNotFoundException e) {
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, String.format("Unknown type '%s' for column '%s' in view: %s", column.getType(), column.getName(), entry.getKey()));
                        }
                    }
                    tableColumns.put((QualifiedObjectName)entry.getKey(), columns.build());
                }
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createSchema(session.toConnectorSession(catalogName), schema.getSchemaName(), properties, principal);
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropSchema(session.toConnectorSession(catalogName), schema.getSchemaName());
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameSchema(session.toConnectorSession(catalogName), source.getSchemaName(), target);
    }

    @Override
    public void setSchemaAuthorization(Session session, CatalogSchemaName source, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.setSchemaAuthorization(session.toConnectorSession(catalogName), source.getSchemaName(), principal);
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createTable(session.toConnectorSession(catalog), tableMetadata, ignoreExisting);
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        if (!tableHandle.getCatalogName().equals(catalog)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameTable(session.toConnectorSession(catalog), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setTableComment(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), comment);
    }

    @Override
    public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setColumnComment(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column, comment);
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.renameColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.addColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.dropColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void setTableAuthorization(Session session, CatalogSchemaTableName table, TrinoPrincipal principal) {
        CatalogName catalogName = new CatalogName(table.getCatalogName());
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setTableAuthorization(session.toConnectorSession(catalogName), table.getSchemaTableName(), principal);
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.dropTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<NewTableLayout> getInsertLayout(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        return metadata.getInsertLayout(session.toConnectorSession(catalogName), table.getConnectorHandle()).map(layout -> new NewTableLayout(catalogName, catalogMetadata.getTransactionHandleFor(catalogName), (ConnectorNewTableLayout)layout));
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        CatalogName catalog = catalogMetadata.getCatalogName();
        return metadata.getStatisticsCollectionMetadataForWrite(session.toConnectorSession(catalog), tableMetadata);
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadata(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        CatalogName catalog = catalogMetadata.getCatalogName();
        return metadata.getStatisticsCollectionMetadata(session.toConnectorSession(catalog), tableMetadata);
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorTableHandle connectorTableHandle = metadata.beginStatisticsCollection(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new AnalyzeTableHandle(catalogName, transactionHandle, connectorTableHandle);
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        catalogMetadata.getMetadata().finishStatisticsCollection(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), computedStatistics);
    }

    @Override
    public Optional<NewTableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalog);
        ConnectorSession connectorSession = session.toConnectorSession(catalog);
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new NewTableLayout(catalog, transactionHandle, (ConnectorNewTableLayout)layout));
    }

    @Override
    public void cleanupQuery(Session session) {
        QueryCatalogs queryCatalogs = (QueryCatalogs)this.catalogsByQueryId.remove(session.getQueryId());
        if (queryCatalogs != null) {
            queryCatalogs.finish();
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalog);
        ConnectorSession connectorSession = session.toConnectorSession(catalog);
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(NewTableLayout::getLayout));
        return new OutputTableHandle(catalog, transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.finishCreateTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), columns);
        return new InsertTableHandle(tableHandle.getCatalogName(), transactionHandle, handle);
    }

    @Override
    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        return catalogMetadata.getMetadata().supportsMissingColumnsOnInsert();
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.finishInsert(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle, List<TableHandle> sourceTableHandles) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        List sourceConnectorHandles = sourceTableHandles.stream().map(TableHandle::getConnectorHandle).collect(Collectors.toList());
        sourceConnectorHandles.add(tableHandle.getConnectorHandle());
        if (sourceConnectorHandles.stream().map(Object::getClass).distinct().count() > 1L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cross connector materialized views are not supported");
        }
        ConnectorInsertTableHandle handle = metadata.beginRefreshMaterializedView(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), sourceConnectorHandles);
        return new InsertTableHandle(tableHandle.getCatalogName(), transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, TableHandle tableHandle, InsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<TableHandle> sourceTableHandles) {
        CatalogName catalogName = insertHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        List sourceConnectorHandles = (List)sourceTableHandles.stream().map(TableHandle::getConnectorHandle).collect(ImmutableList.toImmutableList());
        return metadata.finishRefreshMaterializedView(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), insertHandle.getConnectorHandle(), fragments, computedStatistics, sourceConnectorHandles);
    }

    @Override
    public ColumnHandle getDeleteRowIdColumnHandle(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getDeleteRowIdColumnHandle(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getUpdateRowIdColumnHandle(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), updatedColumns);
    }

    @Override
    public boolean supportsMetadataDelete(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (!metadata.usesLegacyTableLayouts()) {
            return false;
        }
        return metadata.supportsMetadataDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), tableHandle.getLayout().get());
    }

    @Override
    public Optional<TableHandle> applyDelete(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyDelete(connectorSession, table.getConnectorHandle()).map(newHandle -> new TableHandle(catalogName, (ConnectorTableHandle)newHandle, table.getTransaction(), Optional.empty()));
    }

    @Override
    public OptionalLong executeDelete(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            Preconditions.checkArgument((boolean)table.getLayout().isPresent(), (Object)"table layout is missing");
            return metadata.metadataDelete(session.toConnectorSession(catalogName), table.getConnectorHandle(), table.getLayout().get());
        }
        Preconditions.checkArgument((boolean)table.getLayout().isEmpty(), (Object)"table layout should not be present");
        return metadata.executeDelete(connectorSession, table.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorTableHandle newHandle = metadata.beginDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getCatalogName(), newHandle, tableHandle.getTransaction(), tableHandle.getLayout());
    }

    @Override
    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.finishDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public TableHandle beginUpdate(Session session, TableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorTableHandle newHandle = metadata.beginUpdate(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), updatedColumns);
        return new TableHandle(tableHandle.getCatalogName(), newHandle, tableHandle.getTransaction(), tableHandle.getLayout());
    }

    @Override
    public void finishUpdate(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.finishUpdate(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName).map(CatalogMetadata::getCatalogName);
    }

    @Override
    public Map<String, CatalogName> getCatalogNames(Session session) {
        return this.transactionManager.getCatalogNames(session.getRequiredTransactionId());
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return (List)this.getView(session, objectName.get()).map(handle -> ImmutableList.of((Object)((QualifiedObjectName)objectName.get()))).orElseGet(ImmutableList::of);
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet views = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listViews(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(views::add);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ConnectorViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ConnectorViewDefinition> views = new LinkedHashMap<QualifiedObjectName, ConnectorViewDefinition>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                Map viewMap = tablePrefix.getTable().isPresent() ? (Map)metadata.getView(connectorSession, tablePrefix.toSchemaTableName()).map(view -> ImmutableMap.of((Object)tablePrefix.toSchemaTableName(), (Object)view)).orElse(ImmutableMap.of()) : metadata.getViews(connectorSession, tablePrefix.getSchema());
                for (Map.Entry entry : viewMap.entrySet()) {
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, (ConnectorViewDefinition)entry.getValue());
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(schemaName.getCatalogName()));
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.getSchemaProperties(connectorSession, schemaName);
    }

    @Override
    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(schemaName.getCatalogName()));
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.getSchemaOwner(connectorSession, schemaName);
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        if (viewName.getCatalogName().isEmpty() || viewName.getSchemaName().isEmpty() || viewName.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, ConnectorViewDefinition definition, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createView(session.toConnectorSession(catalogName), viewName.asSchemaTableName(), definition, replace);
    }

    @Override
    public void renameView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, target.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        if (!source.getCatalogName().equals(catalogName.getCatalogName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename views across catalogs");
        }
        metadata.renameView(session.toConnectorSession(catalogName), source.asSchemaTableName(), target.asSchemaTableName());
    }

    @Override
    public void setViewAuthorization(Session session, CatalogSchemaTableName view, TrinoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, view.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.setViewAuthorization(session.toConnectorSession(catalogName), view.getSchemaTableName(), principal);
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropView(session.toConnectorSession(catalogName), viewName.asSchemaTableName());
    }

    @Override
    public void createMaterializedView(Session session, QualifiedObjectName viewName, ConnectorMaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createMaterializedView(session.toConnectorSession(catalogName), viewName.asSchemaTableName(), definition, replace, ignoreExisting);
    }

    @Override
    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropMaterializedView(session.toConnectorSession(catalogName), viewName.asSchemaTableName());
    }

    @Override
    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        if (viewName.getCatalogName().isEmpty() || viewName.getSchemaName().isEmpty() || viewName.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getMaterializedView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public MaterializedViewFreshness getMaterializedViewFreshness(Session session, QualifiedObjectName viewName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getMaterializedViewFreshness(connectorSession, viewName.asSchemaTableName());
        }
        return new MaterializedViewFreshness(false);
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyTableScanRedirect(connectorSession, tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getCatalogName(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public boolean usesLegacyTableLayouts(Session session, TableHandle table) {
        return this.getMetadata(session, table.getCatalogName()).usesLegacyTableLayouts();
    }

    @Override
    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyLimit(connectorSession, table.getConnectorHandle(), limit).map(result -> new LimitApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.isLimitGuaranteed()));
    }

    @Override
    public Optional<TableHandle> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applySample(connectorSession, table.getConnectorHandle(), sampleType, sampleRatio).map(result -> new TableHandle(catalogName, (ConnectorTableHandle)result, table.getTransaction(), Optional.empty()));
    }

    @Override
    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        Preconditions.checkArgument((!groupingSets.isEmpty() ? 1 : 0) != 0, (Object)"No grouping sets provided");
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyAggregation(connectorSession, table.getConnectorHandle(), aggregations, assignments, groupingSets).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), aggregations.size());
            return new AggregationApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.getProjections(), result.getAssignments(), result.getGroupingColumnMapping());
        });
    }

    @Override
    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session session, JoinType joinType, TableHandle left, TableHandle right, List<JoinCondition> joinConditions, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        if (!right.getCatalogName().equals(left.getCatalogName())) {
            return Optional.empty();
        }
        CatalogName catalogName = left.getCatalogName();
        ConnectorTransactionHandle transaction = left.getTransaction();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        Optional connectorResult = metadata.applyJoin(connectorSession, joinType, left.getConnectorHandle(), right.getConnectorHandle(), joinConditions, leftAssignments, rightAssignments, statistics);
        return connectorResult.map(result -> {
            ImmutableSet leftColumnHandles = ImmutableSet.copyOf(this.getColumnHandles(session, left).values());
            ImmutableSet rightColumnHandles = ImmutableSet.copyOf(this.getColumnHandles(session, right).values());
            Set leftColumnHandlesMappingKeys = result.getLeftColumnHandles().keySet();
            Set rightColumnHandlesMappingKeys = result.getRightColumnHandles().keySet();
            if (leftColumnHandlesMappingKeys.size() != leftColumnHandles.size() || rightColumnHandlesMappingKeys.size() != rightColumnHandles.size() || !leftColumnHandlesMappingKeys.containsAll((Collection<?>)leftColumnHandles) || !rightColumnHandlesMappingKeys.containsAll((Collection<?>)rightColumnHandles)) {
                throw new IllegalStateException(String.format("Column handle mappings do not match old column handles: left=%s; right=%s; newLeft=%s, newRight=%s", leftColumnHandles, rightColumnHandles, leftColumnHandlesMappingKeys, rightColumnHandlesMappingKeys));
            }
            return new JoinApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getTableHandle(), transaction, Optional.empty()), result.getLeftColumnHandles(), result.getRightColumnHandles());
        });
    }

    @Override
    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session session, TableHandle table, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyTopN(connectorSession, table.getConnectorHandle(), topNCount, sortItems, assignments).map(result -> new TopNApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.isTopNGuaranteed()));
    }

    private void verifyProjection(TableHandle table, List<ConnectorExpression> projections, List<Assignment> assignments, int expectedProjectionSize) {
        projections.forEach(projection -> Objects.requireNonNull(projection, "one of the projections is null"));
        assignments.forEach(assignment -> Objects.requireNonNull(assignment, "one of the assignments is null"));
        Verify.verify((expectedProjectionSize == projections.size() ? 1 : 0) != 0, (String)"ConnectorMetadata returned invalid number of projections: %s instead of %s for %s", (Object)projections.size(), (Object)expectedProjectionSize, (Object)table);
        Set assignedVariables = (Set)assignments.stream().map(Assignment::getVariable).collect(ImmutableSet.toImmutableSet());
        projections.stream().flatMap(connectorExpression -> ConnectorExpressions.extractVariables(connectorExpression).stream()).map(Variable::getName).filter(variableName -> !assignedVariables.contains(variableName)).findAny().ifPresent(variableName -> {
            throw new IllegalStateException("Unbound variable: " + variableName);
        });
    }

    @Override
    public void validateScan(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.validateScan(session.toConnectorSession(catalogName), table.getConnectorHandle());
    }

    @Override
    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyFilter(connectorSession, table.getConnectorHandle(), constraint).map(result -> new ConstraintApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.getRemainingFilter()));
    }

    @Override
    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyProjection(connectorSession, table.getConnectorHandle(), projections, assignments).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), projections.size());
            return new ProjectionApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.getProjections(), result.getAssignments());
        });
    }

    @Override
    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createRole(session.toConnectorSession(catalogName), role, grantor);
    }

    @Override
    public void dropRole(Session session, String role, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropRole(session.toConnectorSession(catalogName), role);
    }

    @Override
    public Set<String> listRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return (Set)metadata.listRoles(connectorSession).stream().map(role -> role.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<RoleGrant> listAllRoleGrants(Session session, String catalog, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return metadata.listAllRoleGrants(connectorSession, roles, grantees, limit);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, String catalog, TrinoPrincipal principal) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return metadata.listRoleGrants(connectorSession, principal);
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantRoles(session.toConnectorSession(catalogName), roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeRoles(session.toConnectorSession(catalogName), roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return ImmutableSet.copyOf((Collection)metadata.listApplicableRoles(connectorSession, principal));
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return ImmutableSet.copyOf((Collection)metadata.listEnabledRoles(connectorSession));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantSchemaPrivileges(session.toConnectorSession(catalogName), schemaName.getSchemaName(), privileges, grantee, grantOption);
    }

    @Override
    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schemaName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeSchemaPrivileges(session.toConnectorSession(catalogName), schemaName.getSchemaName(), privileges, grantee, grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        ImmutableSet.Builder grantInfos = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
            List connectorIds = prefix.asQualifiedObjectName().map(qualifiedTableName -> Collections.singletonList(catalogMetadata.getConnectorId(session, (QualifiedObjectName)qualifiedTableName))).orElseGet(catalogMetadata::listConnectorIds);
            for (CatalogName catalogName : connectorIds) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                grantInfos.addAll((Iterable)metadata.listTablePrivileges(connectorSession, prefix.asSchemaTablePrefix()));
            }
        }
        return ImmutableList.copyOf((Collection)grantInfos.build());
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.typeRegistry.getType((TypeManager)new InternalTypeManager(this, this.typeOperators), signature);
    }

    @Override
    public Type fromSqlType(String sqlType) {
        return this.typeRegistry.fromSqlType(new InternalTypeManager(this, this.typeOperators), sqlType);
    }

    @Override
    public Type getType(TypeId id) {
        return this.typeRegistry.getType((TypeManager)new InternalTypeManager(this, this.typeOperators), id);
    }

    @Override
    public Collection<Type> getTypes() {
        return this.typeRegistry.getTypes();
    }

    @Override
    public Collection<ParametricType> getParametricTypes() {
        return this.typeRegistry.getParametricTypes();
    }

    public void addType(Type type) {
        this.typeRegistry.addType(type);
    }

    public void addParametricType(ParametricType parametricType) {
        this.typeRegistry.addParametricType(parametricType);
    }

    @Override
    public void verifyTypes() {
        HashSet<Type> missingOperatorDeclaration = new HashSet<Type>();
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : this.typeRegistry.getTypes()) {
            if (type.getTypeOperatorDeclaration(this.typeOperators) == null) {
                missingOperatorDeclaration.add(type);
                continue;
            }
            if (type.isComparable()) {
                if (!this.hasEqualMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.EQUAL);
                }
                if (!this.hasHashCodeMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.HASH_CODE);
                }
                if (!this.hasXxHash64Method(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.XX_HASH_64);
                }
                if (!this.hasDistinctFromMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.IS_DISTINCT_FROM);
                }
                if (!this.hasIndeterminateMethod(type)) {
                    missingOperators.put((Object)type, (Object)OperatorType.INDETERMINATE);
                }
            }
            if (!type.isOrderable()) continue;
            if (!this.hasComparisonMethod(type)) {
                missingOperators.put((Object)type, (Object)OperatorType.COMPARISON);
            }
            if (!this.hasLessThanMethod(type)) {
                missingOperators.put((Object)type, (Object)OperatorType.LESS_THAN);
            }
            if (this.hasLessThanOrEqualMethod(type)) continue;
            missingOperators.put((Object)type, (Object)OperatorType.LESS_THAN_OR_EQUAL);
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperatorDeclaration) {
                messages.add(String.format("%s types operators is null", type));
            }
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    private boolean hasEqualMethod(Type type) {
        try {
            this.typeOperators.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasHashCodeMethod(Type type) {
        try {
            this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasXxHash64Method(Type type) {
        try {
            this.typeOperators.getXxHash64Operator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasDistinctFromMethod(Type type) {
        try {
            this.typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasIndeterminateMethod(Type type) {
        try {
            this.typeOperators.getIndeterminateOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE}));
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private boolean hasComparisonMethod(Type type) {
        try {
            this.typeOperators.getComparisonOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private boolean hasLessThanMethod(Type type) {
        try {
            this.typeOperators.getLessThanOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    private boolean hasLessThanOrEqualMethod(Type type) {
        try {
            this.typeOperators.getLessThanOrEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}));
            return true;
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    @Override
    public void addFunctions(List<? extends SqlFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public List<FunctionMetadata> listFunctions() {
        return this.functions.list();
    }

    @Override
    public ResolvedFunction decodeFunction(QualifiedName name) {
        return this.functionDecoder.fromQualifiedName(name).orElseThrow(() -> new IllegalArgumentException("Function is not resolved: " + name));
    }

    @Override
    public ResolvedFunction resolveFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return this.functionDecoder.fromQualifiedName(name).orElseGet(() -> this.resolve(this.functionResolver.resolveFunction(this.functions.get(name), name, parameterTypes)));
    }

    @Override
    public ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return (ResolvedFunction)this.operatorCache.getUnchecked((Object)new OperatorCacheKey(operatorType, argumentTypes));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TrinoException) {
                TrinoException cause = (TrinoException)e.getCause();
                if (cause.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, cause);
                }
                throw cause;
            }
            throw e;
        }
    }

    @Override
    public ResolvedFunction getCoercion(OperatorType operatorType, Type fromType, Type toType) {
        Preconditions.checkArgument((operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST ? 1 : 0) != 0);
        try {
            return (ResolvedFunction)this.coercionCache.getUnchecked((Object)new CoercionCacheKey(operatorType, fromType, toType));
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof TrinoException) {
                TrinoException cause = (TrinoException)e.getCause();
                if (cause.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                    throw new OperatorNotFoundException(operatorType, (List<? extends Type>)ImmutableList.of((Object)fromType), toType.getTypeSignature(), cause);
                }
                throw cause;
            }
            throw e;
        }
    }

    @Override
    public ResolvedFunction getCoercion(QualifiedName name, Type fromType, Type toType) {
        return this.resolve(this.functionResolver.resolveCoercion(this.functions.get(name), new Signature(name.getSuffix(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature()))));
    }

    private ResolvedFunction resolve(FunctionBinding functionBinding) {
        FunctionDependencyDeclaration declaration = this.functions.getFunctionDependencies(functionBinding);
        return this.resolve(functionBinding, declaration);
    }

    @VisibleForTesting
    public ResolvedFunction resolve(FunctionBinding functionBinding, FunctionDependencyDeclaration declaration) {
        Map dependentTypes = (Map)declaration.getTypeDependencies().stream().map(typeSignature -> SignatureBinder.applyBoundVariables(typeSignature, functionBinding)).collect(ImmutableMap.toImmutableMap(Function.identity(), this::getType, (left, right) -> left));
        ImmutableSet.Builder functions = ImmutableSet.builder();
        declaration.getFunctionDependencies().stream().map(functionDependency -> {
            try {
                List<TypeSignature> argumentTypes = SignatureBinder.applyBoundVariables(functionDependency.getArgumentTypes(), functionBinding);
                return this.resolveFunction(functionDependency.getName(), TypeSignatureProvider.fromTypeSignatures(argumentTypes));
            }
            catch (TrinoException e) {
                if (functionDependency.isOptional()) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)functions).add(arg_0));
        declaration.getOperatorDependencies().stream().map(operatorDependency -> {
            try {
                List<TypeSignature> argumentTypes = SignatureBinder.applyBoundVariables(operatorDependency.getArgumentTypes(), functionBinding);
                return this.resolveFunction(QualifiedName.of((String)Signature.mangleOperatorName(operatorDependency.getOperatorType())), TypeSignatureProvider.fromTypeSignatures(argumentTypes));
            }
            catch (TrinoException e) {
                if (operatorDependency.isOptional()) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)functions).add(arg_0));
        declaration.getCastDependencies().stream().map(castDependency -> {
            try {
                Type fromType = this.getType(SignatureBinder.applyBoundVariables(castDependency.getFromType(), functionBinding));
                Type toType = this.getType(SignatureBinder.applyBoundVariables(castDependency.getToType(), functionBinding));
                return this.getCoercion(fromType, toType);
            }
            catch (TrinoException e) {
                if (castDependency.isOptional()) {
                    return null;
                }
                throw e;
            }
        }).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)functions).add(arg_0));
        return new ResolvedFunction(functionBinding.getBoundSignature(), functionBinding.getFunctionId(), dependentTypes, (Set<ResolvedFunction>)functions.build());
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.get(name).stream().map(FunctionMetadata::getKind).anyMatch(FunctionKind.AGGREGATE::equals);
    }

    @Override
    public FunctionMetadata getFunctionMetadata(ResolvedFunction resolvedFunction) {
        ImmutableList argumentDefinitions;
        FunctionMetadata functionMetadata = this.functions.get(resolvedFunction.getFunctionId());
        if (functionMetadata.getSignature().isVariableArity()) {
            List<FunctionArgumentDefinition> fixedArguments = functionMetadata.getArgumentDefinitions().subList(0, functionMetadata.getArgumentDefinitions().size() - 1);
            int variableArgumentCount = resolvedFunction.getSignature().getArgumentTypes().size() - fixedArguments.size();
            argumentDefinitions = ImmutableList.builder().addAll(fixedArguments).addAll(Collections.nCopies(variableArgumentCount, functionMetadata.getArgumentDefinitions().get(functionMetadata.getArgumentDefinitions().size() - 1))).build();
        } else {
            argumentDefinitions = functionMetadata.getArgumentDefinitions();
        }
        return new FunctionMetadata(functionMetadata.getFunctionId(), resolvedFunction.getSignature().toSignature(), functionMetadata.getActualName(), functionMetadata.isNullable(), (List<FunctionArgumentDefinition>)argumentDefinitions, functionMetadata.isHidden(), functionMetadata.isDeterministic(), functionMetadata.getDescription(), functionMetadata.getKind(), functionMetadata.isDeprecated());
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(ResolvedFunction resolvedFunction) {
        return this.functions.getAggregationFunctionMetadata(this.toFunctionBinding(resolvedFunction));
    }

    @Override
    public WindowFunctionSupplier getWindowFunctionImplementation(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = new FunctionDependencies(this, resolvedFunction.getTypeDependencies(), resolvedFunction.getFunctionDependencies());
        return this.functions.getWindowFunctionImplementation(this.toFunctionBinding(resolvedFunction), functionDependencies);
    }

    @Override
    public InternalAggregationFunction getAggregateFunctionImplementation(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = new FunctionDependencies(this, resolvedFunction.getTypeDependencies(), resolvedFunction.getFunctionDependencies());
        return this.functions.getAggregateFunctionImplementation(this.toFunctionBinding(resolvedFunction), functionDependencies);
    }

    @Override
    public FunctionInvoker getScalarFunctionInvoker(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        FunctionDependencies functionDependencies = new FunctionDependencies(this, resolvedFunction.getTypeDependencies(), resolvedFunction.getFunctionDependencies());
        FunctionInvoker functionInvoker = this.functions.getScalarFunctionInvoker(this.toFunctionBinding(resolvedFunction), functionDependencies, invocationConvention);
        MetadataManager.verifyMethodHandleSignature(resolvedFunction.getSignature(), functionInvoker, invocationConvention);
        return functionInvoker;
    }

    private static void verifyMethodHandleSignature(BoundSignature boundSignature, FunctionInvoker functionInvoker, InvocationConvention convention) {
        MethodHandle methodHandle = functionInvoker.getMethodHandle();
        MethodType methodType = methodHandle.type();
        Preconditions.checkArgument((convention.getArgumentConventions().size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (String)"Expected %s arguments, but got %s", (int)boundSignature.getArgumentTypes().size(), (int)convention.getArgumentConventions().size());
        int expectedParameterCount = convention.getArgumentConventions().stream().mapToInt(InvocationConvention.InvocationArgumentConvention::getParameterCount).sum();
        expectedParameterCount = (int)((long)expectedParameterCount + methodType.parameterList().stream().filter(ConnectorSession.class::equals).count());
        if (functionInvoker.getInstanceFactory().isPresent()) {
            ++expectedParameterCount;
        }
        Preconditions.checkArgument((expectedParameterCount == methodType.parameterCount() ? 1 : 0) != 0, (String)"Expected %s method parameters, but got %s", (int)expectedParameterCount, (int)methodType.parameterCount());
        int parameterIndex = 0;
        if (functionInvoker.getInstanceFactory().isPresent()) {
            MetadataManager.verifyFunctionSignature(convention.supportsInstanceFactor(), "Method requires instance factory, but calling convention does not support an instance factory", new Object[0]);
            MethodHandle factoryMethod = functionInvoker.getInstanceFactory().orElseThrow();
            MetadataManager.verifyFunctionSignature(methodType.parameterType(parameterIndex).equals(factoryMethod.type().returnType()), "Invalid return type", new Object[0]);
            ++parameterIndex;
        }
        int lambdaArgumentIndex = 0;
        for (int argumentIndex = 0; argumentIndex < boundSignature.getArgumentTypes().size(); ++argumentIndex) {
            while (methodType.parameterType(parameterIndex).equals(ConnectorSession.class)) {
                MetadataManager.verifyFunctionSignature(convention.supportsSession(), "Method requires session, but calling convention does not support session", new Object[0]);
                ++parameterIndex;
            }
            TypeDescriptor.OfField parameterType = methodType.parameterType(parameterIndex);
            Type argumentType = boundSignature.getArgumentTypes().get(argumentIndex);
            InvocationConvention.InvocationArgumentConvention argumentConvention = convention.getArgumentConvention(argumentIndex);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    MetadataManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType, parameterType);
                    break;
                }
                case NULL_FLAG: {
                    MetadataManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType.getJavaType(), parameterType);
                    MetadataManager.verifyFunctionSignature(methodType.parameterType(parameterIndex + 1).equals(Boolean.TYPE), "Expected null flag parameter to be followed by a boolean parameter", new Object[0]);
                    break;
                }
                case BOXED_NULLABLE: {
                    MetadataManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(Primitives.wrap((Class)argumentType.getJavaType())), "Expected argument type to be %s, but is %s", Primitives.wrap((Class)argumentType.getJavaType()), parameterType);
                    break;
                }
                case BLOCK_POSITION: {
                    MetadataManager.verifyFunctionSignature(parameterType.equals(Block.class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE), "Expected BLOCK_POSITION argument have parameters Block and int", new Object[0]);
                    break;
                }
                case FUNCTION: {
                    Class<?> lambdaInterface = functionInvoker.getLambdaInterfaces().get(lambdaArgumentIndex);
                    MetadataManager.verifyFunctionSignature(parameterType.equals(lambdaInterface), "Expected function interface to be %s, but is %s", lambdaInterface, parameterType);
                    ++lambdaArgumentIndex;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown argument convention: " + argumentConvention);
                }
            }
            parameterIndex += argumentConvention.getParameterCount();
        }
        Type returnType = boundSignature.getReturnType();
        switch (convention.getReturnConvention()) {
            case FAIL_ON_NULL: {
                MetadataManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(returnType.getJavaType()), "Expected return type to be %s, but is %s", returnType.getJavaType(), methodType.returnType());
                break;
            }
            case NULLABLE_RETURN: {
                MetadataManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(Primitives.wrap((Class)returnType.getJavaType())), "Expected return type to be %s, but is %s", returnType.getJavaType(), Primitives.wrap((Class)methodType.returnType()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown return convention: " + convention.getReturnConvention());
            }
        }
    }

    private static void verifyFunctionSignature(boolean check, String message, Object ... args) {
        if (!check) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format(message, args));
        }
    }

    private FunctionBinding toFunctionBinding(ResolvedFunction resolvedFunction) {
        Signature functionSignature = this.functions.get(resolvedFunction.getFunctionId()).getSignature();
        return MetadataManager.toFunctionBinding(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionSignature);
    }

    @VisibleForTesting
    public static FunctionBinding toFunctionBinding(FunctionId functionId, BoundSignature boundSignature, Signature functionSignature) {
        return SignatureBinder.bindFunction(functionId, functionSignature, boundSignature);
    }

    @Override
    public ProcedureRegistry getProcedureRegistry() {
        return this.procedures;
    }

    private BlockEncoding getBlockEncoding(String encodingName) {
        BlockEncoding blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding: %s", (Object)encodingName);
        return blockEncoding;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return new InternalBlockEncodingSerde(this::getBlockEncoding, this::getType);
    }

    public void addBlockEncoding(BlockEncoding blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncoding existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        Preconditions.checkArgument((existingEntry == null ? 1 : 0) != 0, (String)"Encoding already registered: %s", (Object)blockEncoding.getName());
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public SchemaPropertyManager getSchemaPropertyManager() {
        return this.schemaPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    @Override
    public MaterializedViewPropertyManager getMaterializedViewPropertyManager() {
        return this.materializedViewPropertyManager;
    }

    @Override
    public ColumnPropertyManager getColumnPropertyManager() {
        return this.columnPropertyManager;
    }

    @Override
    public AnalyzePropertyManager getAnalyzePropertyManager() {
        return this.analyzePropertyManager;
    }

    private Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, String catalogName) {
        Optional<CatalogMetadata> optionalCatalogMetadata = this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        optionalCatalogMetadata.ifPresent(catalogMetadata -> this.registerCatalogForQuery(session, (CatalogMetadata)catalogMetadata));
        return optionalCatalogMetadata;
    }

    private CatalogMetadata getCatalogMetadata(Session session, CatalogName catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, String catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, CatalogName catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private ConnectorMetadata getMetadata(Session session, CatalogName catalogName) {
        return this.getCatalogMetadata(session, catalogName).getMetadataFor(catalogName);
    }

    private ConnectorMetadata getMetadataForWrite(Session session, CatalogName catalogName) {
        return this.getCatalogMetadataForWrite(session, catalogName).getMetadata();
    }

    private void registerCatalogForQuery(Session session, CatalogMetadata catalogMetadata) {
        this.catalogsByQueryId.computeIfAbsent(session.getQueryId(), queryId -> new QueryCatalogs(session)).registerCatalog(catalogMetadata);
    }

    @VisibleForTesting
    public Set<QueryId> getActiveQueryIds() {
        return ImmutableSet.copyOf(this.catalogsByQueryId.keySet());
    }

    private static class CoercionCacheKey {
        private final OperatorType operatorType;
        private final Type fromType;
        private final Type toType;

        private CoercionCacheKey(OperatorType operatorType, Type fromType, Type toType) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public Type getFromType() {
            return this.fromType;
        }

        public Type getToType() {
            return this.toType;
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.fromType, this.toType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CoercionCacheKey)) {
                return false;
            }
            CoercionCacheKey other = (CoercionCacheKey)obj;
            return Objects.equals(this.operatorType, other.operatorType) && Objects.equals(this.fromType, other.fromType) && Objects.equals(this.toType, other.toType);
        }
    }

    private static class OperatorCacheKey {
        private final OperatorType operatorType;
        private final List<? extends Type> argumentTypes;

        private OperatorCacheKey(OperatorType operatorType, List<? extends Type> argumentTypes) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        public List<? extends Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.argumentTypes);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OperatorCacheKey)) {
                return false;
            }
            OperatorCacheKey other = (OperatorCacheKey)obj;
            return Objects.equals(this.operatorType, other.operatorType) && Objects.equals(this.argumentTypes, other.argumentTypes);
        }
    }

    private static class QueryCatalogs {
        private final Session session;
        @GuardedBy(value="this")
        private final Map<CatalogName, CatalogMetadata> catalogs = new HashMap<CatalogName, CatalogMetadata>();
        @GuardedBy(value="this")
        private boolean finished;

        public QueryCatalogs(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        private synchronized void registerCatalog(CatalogMetadata catalogMetadata) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
            if (this.catalogs.putIfAbsent(catalogMetadata.getCatalogName(), catalogMetadata) == null) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogName());
                catalogMetadata.getMetadata().beginQuery(connectorSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void finish() {
            ArrayList<CatalogMetadata> catalogs;
            QueryCatalogs queryCatalogs = this;
            synchronized (queryCatalogs) {
                Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
                this.finished = true;
                catalogs = new ArrayList<CatalogMetadata>(this.catalogs.values());
            }
            for (CatalogMetadata catalogMetadata : catalogs) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogName());
                catalogMetadata.getMetadata().cleanupQuery(connectorSession);
            }
        }
    }
}

