/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.metadata.AggregationFunctionMetadata;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionDependencies;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.SqlFunction;
import io.trino.operator.aggregation.AggregationFromAnnotationsParser;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class SqlAggregationFunction
implements SqlFunction {
    private final FunctionMetadata functionMetadata;
    private final boolean orderSensitive;
    private final boolean decomposable;

    public static List<SqlAggregationFunction> createFunctionByAnnotations(Class<?> aggregationDefinition) {
        return ImmutableList.of((Object)AggregationFromAnnotationsParser.parseFunctionDefinition(aggregationDefinition));
    }

    public static List<SqlAggregationFunction> createFunctionsByAnnotations(Class<?> aggregationDefinition) {
        return (List)AggregationFromAnnotationsParser.parseFunctionDefinitions(aggregationDefinition).stream().map(SqlAggregationFunction.class::cast).collect(ImmutableList.toImmutableList());
    }

    protected SqlAggregationFunction(FunctionMetadata functionMetadata, boolean decomposable, boolean orderSensitive) {
        this.functionMetadata = Objects.requireNonNull(functionMetadata, "functionMetadata is null");
        Preconditions.checkArgument((boolean)functionMetadata.isDeterministic(), (Object)"Aggregation function must be deterministic");
        this.orderSensitive = orderSensitive;
        this.decomposable = decomposable;
    }

    @Override
    public FunctionMetadata getFunctionMetadata() {
        return this.functionMetadata;
    }

    public AggregationFunctionMetadata getAggregationMetadata(FunctionBinding functionBinding) {
        if (!this.decomposable) {
            return new AggregationFunctionMetadata(this.orderSensitive, Optional.empty());
        }
        List<TypeSignature> intermediateTypes = this.getIntermediateTypes(functionBinding);
        TypeSignature intermediateType = intermediateTypes.size() == 1 ? (TypeSignature)Iterables.getOnlyElement(intermediateTypes) : new TypeSignature("row", (List)intermediateTypes.stream().map(TypeSignatureParameter::anonymousField).collect(ImmutableList.toImmutableList()));
        return new AggregationFunctionMetadata(this.orderSensitive, Optional.of(intermediateType));
    }

    protected List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        throw new UnsupportedOperationException();
    }

    public InternalAggregationFunction specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        return this.specialize(functionBinding);
    }

    protected InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        throw new UnsupportedOperationException();
    }
}

