/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryTrackingContext;
import io.trino.operator.BasicWorkProcessorOperatorAdapter;
import io.trino.operator.ChannelSet;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.SetBuilderOperator;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class HashSemiJoinOperator
implements WorkProcessorOperator {
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, SetBuilderOperator.SetSupplier setSupplier, List<? extends Type> probeTypes, int probeJoinChannel, Optional<Integer> probeJoinHashChannel) {
        return BasicWorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, setSupplier, probeTypes, probeJoinChannel, probeJoinHashChannel));
    }

    private HashSemiJoinOperator(WorkProcessor<Page> sourcePages, SetBuilderOperator.SetSupplier channelSetFuture, int probeJoinChannel, Optional<Integer> probeHashChannel, MemoryTrackingContext memoryTrackingContext) {
        this.pages = sourcePages.transform(new SemiJoinPages(channelSetFuture, probeJoinChannel, probeHashChannel, Objects.requireNonNull(memoryTrackingContext, "memoryTrackingContext is null").aggregateUserMemoryContext()));
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    private static class SemiJoinPages
    implements WorkProcessor.Transformation<Page, Page> {
        private final int probeJoinChannel;
        private final ListenableFuture<ChannelSet> channelSetFuture;
        private final Optional<Integer> probeHashChannel;
        private final LocalMemoryContext localMemoryContext;
        @Nullable
        private ChannelSet channelSet;

        public SemiJoinPages(SetBuilderOperator.SetSupplier channelSetFuture, int probeJoinChannel, Optional<Integer> probeHashChannel, AggregatedMemoryContext aggregatedMemoryContext) {
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.channelSetFuture = Objects.requireNonNull(channelSetFuture, "channelSetFuture is null").getChannelSet();
            this.probeJoinChannel = probeJoinChannel;
            this.probeHashChannel = Objects.requireNonNull(probeHashChannel, "probeHashChannel is null");
            this.localMemoryContext = Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext is null").newLocalMemoryContext(SemiJoinPages.class.getSimpleName());
        }

        @Override
        public WorkProcessor.TransformationState<Page> process(Page inputPage) {
            if (inputPage == null) {
                return WorkProcessor.TransformationState.finished();
            }
            if (this.channelSet == null) {
                if (!this.channelSetFuture.isDone()) {
                    this.localMemoryContext.setBytes(inputPage.getSizeInBytes());
                    return WorkProcessor.TransformationState.blocked(this.channelSetFuture);
                }
                MoreFutures.checkSuccess(this.channelSetFuture, (String)"ChannelSet building failed");
                this.channelSet = (ChannelSet)MoreFutures.getFutureValue(this.channelSetFuture);
                this.localMemoryContext.setBytes(0L);
            }
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(inputPage.getPositionCount());
            Page probeJoinPage = inputPage.getColumns(this.probeJoinChannel);
            Optional<Block> hashBlock = this.probeHashChannel.map(arg_0 -> ((Page)inputPage).getBlock(arg_0));
            for (int position = 0; position < inputPage.getPositionCount(); ++position) {
                boolean contains;
                if (probeJoinPage.getBlock(0).isNull(position)) {
                    if (this.channelSet.isEmpty()) {
                        BooleanType.BOOLEAN.writeBoolean(blockBuilder, false);
                        continue;
                    }
                    blockBuilder.appendNull();
                    continue;
                }
                if (hashBlock.isPresent()) {
                    long rawHash = BigintType.BIGINT.getLong(hashBlock.get(), position);
                    contains = this.channelSet.contains(position, probeJoinPage, rawHash);
                } else {
                    contains = this.channelSet.contains(position, probeJoinPage);
                }
                if (!contains && this.channelSet.containsNull()) {
                    blockBuilder.appendNull();
                    continue;
                }
                BooleanType.BOOLEAN.writeBoolean(blockBuilder, contains);
            }
            return WorkProcessor.TransformationState.ofResult(inputPage.appendColumn(blockBuilder.build()));
        }
    }

    private static class Factory
    implements BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SetBuilderOperator.SetSupplier setSupplier;
        private final List<Type> probeTypes;
        private final int probeJoinChannel;
        private final Optional<Integer> probeJoinHashChannel;
        private boolean closed;

        private Factory(int operatorId, PlanNodeId planNodeId, SetBuilderOperator.SetSupplier setSupplier, List<? extends Type> probeTypes, int probeJoinChannel, Optional<Integer> probeJoinHashChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.setSupplier = setSupplier;
            this.probeTypes = ImmutableList.copyOf(probeTypes);
            Preconditions.checkArgument((probeJoinChannel >= 0 ? 1 : 0) != 0, (Object)"probeJoinChannel is negative");
            this.probeJoinChannel = probeJoinChannel;
            this.probeJoinHashChannel = probeJoinHashChannel;
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new HashSemiJoinOperator(sourcePages, this.setSupplier, this.probeJoinChannel, this.probeJoinHashChannel, processorContext.getMemoryTrackingContext());
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return HashSemiJoinOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.setSupplier, this.probeTypes, this.probeJoinChannel, this.probeJoinHashChannel);
        }
    }
}

