/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.ResponseTooLargeException;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.log.Logger;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.TrinoMediaTypes;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.SerializedPage;
import io.trino.operator.PageBufferClientStatus;
import io.trino.operator.PageTooLargeException;
import io.trino.operator.PageTransportErrorException;
import io.trino.operator.PageTransportTimeoutException;
import io.trino.server.remotetask.Backoff;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.analyzer.FeaturesConfig;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public final class HttpPageBufferClient
implements Closeable {
    private static final Logger log = Logger.get(HttpPageBufferClient.class);
    private final String selfAddress;
    private final HttpClient httpClient;
    private final FeaturesConfig.DataIntegrityVerification dataIntegrityVerification;
    private final DataSize maxResponseSize;
    private final boolean acknowledgePages;
    private final URI location;
    private final ClientCallback clientCallback;
    private final ScheduledExecutorService scheduler;
    private final Backoff backoff;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private HttpClient.HttpResponseFuture<?> future;
    @GuardedBy(value="this")
    private DateTime lastUpdate = DateTime.now();
    @GuardedBy(value="this")
    private long token;
    @GuardedBy(value="this")
    private boolean scheduled;
    @GuardedBy(value="this")
    private boolean completed;
    @GuardedBy(value="this")
    private String taskInstanceId;
    private final AtomicLong rowsReceived = new AtomicLong();
    private final AtomicInteger pagesReceived = new AtomicInteger();
    private final AtomicLong rowsRejected = new AtomicLong();
    private final AtomicInteger pagesRejected = new AtomicInteger();
    private final AtomicInteger requestsScheduled = new AtomicInteger();
    private final AtomicInteger requestsCompleted = new AtomicInteger();
    private final AtomicInteger requestsFailed = new AtomicInteger();
    private final Executor pageBufferClientCallbackExecutor;

    public HttpPageBufferClient(String selfAddress, HttpClient httpClient, FeaturesConfig.DataIntegrityVerification dataIntegrityVerification, DataSize maxResponseSize, Duration maxErrorDuration, boolean acknowledgePages, URI location, ClientCallback clientCallback, ScheduledExecutorService scheduler, Executor pageBufferClientCallbackExecutor) {
        this(selfAddress, httpClient, dataIntegrityVerification, maxResponseSize, maxErrorDuration, acknowledgePages, location, clientCallback, scheduler, Ticker.systemTicker(), pageBufferClientCallbackExecutor);
    }

    public HttpPageBufferClient(String selfAddress, HttpClient httpClient, FeaturesConfig.DataIntegrityVerification dataIntegrityVerification, DataSize maxResponseSize, Duration maxErrorDuration, boolean acknowledgePages, URI location, ClientCallback clientCallback, ScheduledExecutorService scheduler, Ticker ticker, Executor pageBufferClientCallbackExecutor) {
        this.selfAddress = Objects.requireNonNull(selfAddress, "selfAddress is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.dataIntegrityVerification = Objects.requireNonNull(dataIntegrityVerification, "dataIntegrityVerification is null");
        this.maxResponseSize = Objects.requireNonNull(maxResponseSize, "maxResponseSize is null");
        this.acknowledgePages = acknowledgePages;
        this.location = Objects.requireNonNull(location, "location is null");
        this.clientCallback = Objects.requireNonNull(clientCallback, "clientCallback is null");
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler is null");
        this.pageBufferClientCallbackExecutor = Objects.requireNonNull(pageBufferClientCallbackExecutor, "pageBufferClientCallbackExecutor is null");
        Objects.requireNonNull(maxErrorDuration, "maxErrorDuration is null");
        Objects.requireNonNull(ticker, "ticker is null");
        this.backoff = new Backoff(maxErrorDuration, ticker);
    }

    public synchronized PageBufferClientStatus getStatus() {
        String state = this.closed ? "closed" : (this.future != null ? "running" : (this.scheduled ? "scheduled" : (this.completed ? "completed" : "queued")));
        String httpRequestState = "not scheduled";
        if (this.future != null) {
            httpRequestState = this.future.getState();
        }
        long rejectedRows = this.rowsRejected.get();
        int rejectedPages = this.pagesRejected.get();
        return new PageBufferClientStatus(this.location, state, this.lastUpdate, this.rowsReceived.get(), this.pagesReceived.get(), rejectedRows == 0L ? OptionalLong.empty() : OptionalLong.of(rejectedRows), rejectedPages == 0 ? OptionalInt.empty() : OptionalInt.of(rejectedPages), this.requestsScheduled.get(), this.requestsCompleted.get(), this.requestsFailed.get(), httpRequestState);
    }

    public synchronized boolean isRunning() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClient.HttpResponseFuture<?> future;
        boolean shouldSendDelete;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            shouldSendDelete = !this.closed;
            this.closed = true;
            future = this.future;
            this.future = null;
            this.lastUpdate = DateTime.now();
        }
        if (future != null && !future.isDone()) {
            future.cancel(true);
        }
        if (shouldSendDelete) {
            this.sendDelete();
        }
    }

    public synchronized void scheduleRequest() {
        if (this.closed || this.future != null || this.scheduled) {
            return;
        }
        this.scheduled = true;
        this.backoff.startRequest();
        long delayNanos = this.backoff.getBackoffDelayNanos();
        this.scheduler.schedule(() -> {
            try {
                this.initiateRequest();
            }
            catch (Throwable t) {
                this.clientCallback.clientFailed(this, t);
            }
        }, delayNanos, TimeUnit.NANOSECONDS);
        this.lastUpdate = DateTime.now();
        this.requestsScheduled.incrementAndGet();
    }

    private synchronized void initiateRequest() {
        this.scheduled = false;
        if (this.closed || this.future != null) {
            return;
        }
        if (this.completed) {
            this.sendDelete();
        } else {
            this.sendGetResults();
        }
        this.lastUpdate = DateTime.now();
    }

    private synchronized void sendGetResults() {
        HttpClient.HttpResponseFuture resultFuture;
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.location).appendPath(String.valueOf(this.token)).build();
        this.future = resultFuture = this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Trino-Max-Size", this.maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new PageResponseHandler(this.dataIntegrityVerification != FeaturesConfig.DataIntegrityVerification.NONE));
        Futures.addCallback((ListenableFuture)resultFuture, (FutureCallback)new FutureCallback<PagesResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(PagesResponse result) {
                HttpPageBufferClient.assertNotHoldsLock(this);
                HttpPageBufferClient.this.backoff.success();
                try {
                    Object pages;
                    boolean shouldAcknowledge = false;
                    HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                    synchronized (httpPageBufferClient) {
                        if (HttpPageBufferClient.this.taskInstanceId == null) {
                            HttpPageBufferClient.this.taskInstanceId = result.getTaskInstanceId();
                        }
                        if (!Strings.isNullOrEmpty((String)HttpPageBufferClient.this.taskInstanceId) && !result.getTaskInstanceId().equals(HttpPageBufferClient.this.taskInstanceId)) {
                            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_MISMATCH, String.format("%s (%s). Expected taskInstanceId: %s, received taskInstanceId: %s", "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", HostAddress.fromUri((URI)uri), HttpPageBufferClient.this.taskInstanceId, result.getTaskInstanceId()));
                        }
                        if (result.getToken() == HttpPageBufferClient.this.token) {
                            pages = result.getPages();
                            HttpPageBufferClient.this.token = result.getNextToken();
                            shouldAcknowledge = pages.size() > 0;
                        } else {
                            pages = ImmutableList.of();
                        }
                    }
                    if (shouldAcknowledge && HttpPageBufferClient.this.acknowledgePages) {
                        final URI uri2 = HttpUriBuilder.uriBuilderFrom((URI)HttpPageBufferClient.this.location).appendPath(String.valueOf(result.getNextToken())).appendPath("acknowledge").build();
                        HttpPageBufferClient.this.httpClient.executeAsync(Request.Builder.prepareGet().setUri(uri2).build(), (ResponseHandler)new ResponseHandler<Void, RuntimeException>(){

                            public Void handleException(Request request, Exception exception) {
                                log.debug((Throwable)exception, "Acknowledge request failed: %s", new Object[]{uri2});
                                return null;
                            }

                            public Void handle(Request request, Response response) {
                                if (HttpStatus.familyForStatusCode((int)response.getStatusCode()) != HttpStatus.Family.SUCCESSFUL) {
                                    log.debug("Unexpected acknowledge response code: %s", new Object[]{response.getStatusCode()});
                                }
                                return null;
                            }
                        });
                    }
                    if (HttpPageBufferClient.this.clientCallback.addPages(HttpPageBufferClient.this, (List<SerializedPage>)pages)) {
                        HttpPageBufferClient.this.pagesReceived.addAndGet(pages.size());
                        HttpPageBufferClient.this.rowsReceived.addAndGet(pages.stream().mapToLong(SerializedPage::getPositionCount).sum());
                    } else {
                        HttpPageBufferClient.this.pagesRejected.addAndGet(pages.size());
                        HttpPageBufferClient.this.rowsRejected.addAndGet(pages.stream().mapToLong(SerializedPage::getPositionCount).sum());
                    }
                }
                catch (TrinoException e) {
                    HttpPageBufferClient.this.handleFailure(e, resultFuture);
                    return;
                }
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    if (result.isClientComplete()) {
                        HttpPageBufferClient.this.completed = true;
                    }
                    if (HttpPageBufferClient.this.future == resultFuture) {
                        HttpPageBufferClient.this.future = null;
                    }
                    HttpPageBufferClient.this.lastUpdate = DateTime.now();
                }
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient.this.clientCallback.requestComplete(HttpPageBufferClient.this);
            }

            public void onFailure(Throwable t) {
                log.debug("Request to %s failed %s", new Object[]{uri, t});
                HttpPageBufferClient.assertNotHoldsLock(this);
                if (t instanceof ChecksumVerificationException) {
                    switch (HttpPageBufferClient.this.dataIntegrityVerification) {
                        case NONE: 
                        case ABORT: {
                            t = new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Checksum verification failure on %s when reading from %s: %s", HttpPageBufferClient.this.selfAddress, uri, t.getMessage()), t);
                            break;
                        }
                        case RETRY: {
                            log.warn("Checksum verification failure on %s when reading from %s, may be retried: %s", new Object[]{HttpPageBufferClient.this.selfAddress, uri, t.getMessage()});
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("Unsupported option: " + HttpPageBufferClient.this.dataIntegrityVerification));
                        }
                    }
                }
                if (!((t = HttpPageBufferClient.rewriteException(t)) instanceof TrinoException) && HttpPageBufferClient.this.backoff.failure()) {
                    String message = String.format("%s (%s - %s failures, failure duration %s, total failed request time %s)", "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.", uri, HttpPageBufferClient.this.backoff.getFailureCount(), HttpPageBufferClient.this.backoff.getFailureDuration().convertTo(TimeUnit.SECONDS), HttpPageBufferClient.this.backoff.getFailureRequestTimeTotal().convertTo(TimeUnit.SECONDS));
                    t = new PageTransportTimeoutException(HostAddress.fromUri((URI)uri), message, (Throwable)t);
                }
                HttpPageBufferClient.this.handleFailure((Throwable)t, (HttpClient.HttpResponseFuture<?>)resultFuture);
            }
        }, (Executor)this.pageBufferClientCallbackExecutor);
    }

    private synchronized void sendDelete() {
        HttpClient.HttpResponseFuture resultFuture;
        this.future = resultFuture = this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(this.location).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Futures.addCallback((ListenableFuture)resultFuture, (FutureCallback)new FutureCallback<StatusResponseHandler.StatusResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(@Nullable StatusResponseHandler.StatusResponse result) {
                HttpPageBufferClient.assertNotHoldsLock(this);
                HttpPageBufferClient.this.backoff.success();
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    HttpPageBufferClient.this.closed = true;
                    if (HttpPageBufferClient.this.future == resultFuture) {
                        HttpPageBufferClient.this.future = null;
                    }
                    HttpPageBufferClient.this.lastUpdate = DateTime.now();
                }
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient.this.clientCallback.clientFinished(HttpPageBufferClient.this);
            }

            public void onFailure(Throwable t) {
                HttpPageBufferClient.assertNotHoldsLock(this);
                log.error("Request to delete %s failed %s", new Object[]{HttpPageBufferClient.this.location, t});
                if (!(t instanceof TrinoException) && HttpPageBufferClient.this.backoff.failure()) {
                    String message = String.format("Error closing remote buffer (%s - %s failures, failure duration %s, total failed request time %s)", HttpPageBufferClient.this.location, HttpPageBufferClient.this.backoff.getFailureCount(), HttpPageBufferClient.this.backoff.getFailureDuration().convertTo(TimeUnit.SECONDS), HttpPageBufferClient.this.backoff.getFailureRequestTimeTotal().convertTo(TimeUnit.SECONDS));
                    t = new TrinoException((ErrorCodeSupplier)StandardErrorCode.REMOTE_BUFFER_CLOSE_FAILED, message, t);
                }
                HttpPageBufferClient.this.handleFailure(t, resultFuture);
            }
        }, (Executor)this.pageBufferClientCallbackExecutor);
    }

    private static void assertNotHoldsLock(Object lock) {
        assert (!Thread.holdsLock(lock)) : "Cannot execute this method while holding a lock";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailure(Throwable t, HttpClient.HttpResponseFuture<?> expectedFuture) {
        HttpPageBufferClient.assertNotHoldsLock(this);
        this.requestsFailed.incrementAndGet();
        this.requestsCompleted.incrementAndGet();
        if (t instanceof TrinoException) {
            this.clientCallback.clientFailed(this, t);
        }
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            if (this.future == expectedFuture) {
                this.future = null;
            }
            this.lastUpdate = DateTime.now();
        }
        this.clientCallback.requestComplete(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpPageBufferClient that = (HttpPageBufferClient)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String state;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            state = this.closed ? "CLOSED" : (this.future != null ? "RUNNING" : "QUEUED");
        }
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).addValue((Object)state).toString();
    }

    private static Throwable rewriteException(Throwable t) {
        if (t instanceof ResponseTooLargeException) {
            return new PageTooLargeException();
        }
        return t;
    }

    private static class ChecksumVerificationException
    extends RuntimeException {
        public ChecksumVerificationException(String message) {
            super(Objects.requireNonNull(message, "message is null"));
        }
    }

    public static class PagesResponse {
        private final String taskInstanceId;
        private final long token;
        private final long nextToken;
        private final List<SerializedPage> pages;
        private final boolean clientComplete;

        public static PagesResponse createPagesResponse(String taskInstanceId, long token, long nextToken, Iterable<SerializedPage> pages, boolean complete) {
            return new PagesResponse(taskInstanceId, token, nextToken, pages, complete);
        }

        public static PagesResponse createEmptyPagesResponse(String taskInstanceId, long token, long nextToken, boolean complete) {
            return new PagesResponse(taskInstanceId, token, nextToken, (Iterable<SerializedPage>)ImmutableList.of(), complete);
        }

        private PagesResponse(String taskInstanceId, long token, long nextToken, Iterable<SerializedPage> pages, boolean clientComplete) {
            this.taskInstanceId = taskInstanceId;
            this.token = token;
            this.nextToken = nextToken;
            this.pages = ImmutableList.copyOf(pages);
            this.clientComplete = clientComplete;
        }

        public long getToken() {
            return this.token;
        }

        public long getNextToken() {
            return this.nextToken;
        }

        public List<SerializedPage> getPages() {
            return this.pages;
        }

        public boolean isClientComplete() {
            return this.clientComplete;
        }

        public String getTaskInstanceId() {
            return this.taskInstanceId;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("pagesSize", this.pages.size()).add("clientComplete", this.clientComplete).toString();
        }
    }

    public static class PageResponseHandler
    implements ResponseHandler<PagesResponse, RuntimeException> {
        private final boolean dataIntegrityVerificationEnabled;

        private PageResponseHandler(boolean dataIntegrityVerificationEnabled) {
            this.dataIntegrityVerificationEnabled = dataIntegrityVerificationEnabled;
        }

        public PagesResponse handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public PagesResponse handle(Request request, Response response) {
            PagesResponse pagesResponse;
            URI uri = request.getUri();
            if (response.getStatusCode() == HttpStatus.NO_CONTENT.code()) {
                return PagesResponse.createEmptyPagesResponse(PageResponseHandler.getTaskInstanceId(response, uri), PageResponseHandler.getToken(response, uri), PageResponseHandler.getNextToken(response, uri), PageResponseHandler.getComplete(response, uri));
            }
            if (response.getStatusCode() != HttpStatus.OK.code()) {
                StringBuilder body = new StringBuilder();
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    for (int i = 0; i < 1000 && (line = reader2.readLine()) != null; ++i) {
                        if (body.length() + line.length() > 102400) {
                            break;
                        }
                        body.append(line + "\n");
                    }
                }
                catch (IOException | RuntimeException reader2) {
                    // empty catch block
                }
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Expected response code to be 200, but was %s:%n%s", response.getStatusCode(), body.toString()));
            }
            String contentType = response.getHeader("Content-Type");
            if (contentType == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("%s header is not set: %s", "Content-Type", response));
            }
            if (!PageResponseHandler.mediaTypeMatches(contentType, TrinoMediaTypes.TRINO_PAGES_TYPE)) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Expected %s response from server but got %s", TrinoMediaTypes.TRINO_PAGES_TYPE, contentType));
            }
            String taskInstanceId = PageResponseHandler.getTaskInstanceId(response, uri);
            long token = PageResponseHandler.getToken(response, uri);
            long nextToken = PageResponseHandler.getNextToken(response, uri);
            boolean complete = PageResponseHandler.getComplete(response, uri);
            InputStreamSliceInput input = new InputStreamSliceInput(response.getInputStream());
            try {
                int magic = input.readInt();
                if (magic != -22745087) {
                    throw new IllegalStateException(String.format("Invalid stream header, expected 0x%08x, but was 0x%08x", -22745087, magic));
                }
                long checksum = input.readLong();
                int pagesCount = input.readInt();
                ImmutableList pages = ImmutableList.copyOf(PagesSerdeUtil.readSerializedPages((SliceInput)input));
                this.verifyChecksum(checksum, (List<SerializedPage>)pages);
                Preconditions.checkState((pages.size() == pagesCount ? 1 : 0) != 0, (String)"Wrong number of pages, expected %s, but read %s", (int)pagesCount, (int)pages.size());
                pagesResponse = PagesResponse.createPagesResponse(taskInstanceId, token, nextToken, (Iterable<SerializedPage>)pages, complete);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (PageTransportErrorException e) {
                    throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Error fetching %s: %s", request.getUri().toASCIIString(), e.getMessage()), (Throwable)((Object)e));
                }
            }
            input.close();
            return pagesResponse;
        }

        private void verifyChecksum(long readChecksum, List<SerializedPage> pages) {
            if (this.dataIntegrityVerificationEnabled) {
                long calculatedChecksum = PagesSerdeUtil.calculateChecksum(pages);
                if (readChecksum != calculatedChecksum) {
                    throw new ChecksumVerificationException(String.format("Data corruption, read checksum: 0x%08x, calculated checksum: 0x%08x", readChecksum, calculatedChecksum));
                }
            } else if (readChecksum != 81985529216486895L) {
                throw new ChecksumVerificationException(String.format("Expected checksum to be NO_CHECKSUM (0x%08x) but is 0x%08x", 81985529216486895L, readChecksum));
            }
        }

        private static String getTaskInstanceId(Response response, URI uri) {
            String taskInstanceId = response.getHeader("X-Trino-Task-Instance-Id");
            if (taskInstanceId == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Expected %s header", "X-Trino-Task-Instance-Id"));
            }
            return taskInstanceId;
        }

        private static long getToken(Response response, URI uri) {
            String tokenHeader = response.getHeader("X-Trino-Page-Sequence-Id");
            if (tokenHeader == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Expected %s header", "X-Trino-Page-Sequence-Id"));
            }
            return Long.parseLong(tokenHeader);
        }

        private static long getNextToken(Response response, URI uri) {
            String nextTokenHeader = response.getHeader("X-Trino-Page-End-Sequence-Id");
            if (nextTokenHeader == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Expected %s header", "X-Trino-Page-End-Sequence-Id"));
            }
            return Long.parseLong(nextTokenHeader);
        }

        private static boolean getComplete(Response response, URI uri) {
            String bufferComplete = response.getHeader("X-Trino-Buffer-Complete");
            if (bufferComplete == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)uri), String.format("Expected %s header", "X-Trino-Buffer-Complete"));
            }
            return Boolean.parseBoolean(bufferComplete);
        }

        private static boolean mediaTypeMatches(String value, MediaType range) {
            try {
                return MediaType.parse((String)value).is(range);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return false;
            }
        }
    }

    public static interface ClientCallback {
        public boolean addPages(HttpPageBufferClient var1, List<SerializedPage> var2);

        public void requestComplete(HttpPageBufferClient var1);

        public void clientFinished(HttpPageBufferClient var1);

        public void clientFailed(HttpPageBufferClient var1, Throwable var2);
    }
}

