/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.operator.ArrayPositionLinks;
import io.trino.operator.JoinFilterFunction;
import io.trino.operator.JoinHash;
import io.trino.operator.JoinUtils;
import io.trino.operator.LookupSourceSupplier;
import io.trino.operator.PagesHash;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PositionLinks;
import io.trino.operator.SortedPositionLinks;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JoinHashSupplier
implements LookupSourceSupplier {
    private final Session session;
    private final PagesHash pagesHash;
    private final LongArrayList addresses;
    private final List<Page> pages;
    private final Optional<PositionLinks.Factory> positionLinks;
    private final Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory;
    private final List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories;

    public JoinHashSupplier(Session session, PagesHashStrategy pagesHashStrategy, LongArrayList addresses, List<List<Block>> channels, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory, Optional<Integer> sortChannel, List<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> searchFunctionFactories) {
        PositionLinks.FactoryBuilder positionLinksFactoryBuilder;
        this.session = Objects.requireNonNull(session, "session is null");
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.filterFunctionFactory = Objects.requireNonNull(filterFunctionFactory, "filterFunctionFactory is null");
        this.searchFunctionFactories = ImmutableList.copyOf(searchFunctionFactories);
        Objects.requireNonNull(channels, "channels is null");
        Objects.requireNonNull(pagesHashStrategy, "pagesHashStrategy is null");
        if (sortChannel.isPresent()) {
            Preconditions.checkArgument((boolean)filterFunctionFactory.isPresent(), (Object)"filterFunctionFactory not set while sortChannel set");
            positionLinksFactoryBuilder = SortedPositionLinks.builder(addresses.size(), pagesHashStrategy, addresses);
        } else {
            positionLinksFactoryBuilder = ArrayPositionLinks.builder(addresses.size());
        }
        this.pages = JoinUtils.channelsToPages(channels);
        this.pagesHash = new PagesHash(addresses, pagesHashStrategy, positionLinksFactoryBuilder);
        this.positionLinks = positionLinksFactoryBuilder.isEmpty() ? Optional.empty() : Optional.of(positionLinksFactoryBuilder.build());
    }

    @Override
    public long getHashCollisions() {
        return this.pagesHash.getHashCollisions();
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.pagesHash.getExpectedHashCollisions();
    }

    @Override
    public long checksum() {
        return this.positionLinks.map(PositionLinks.Factory::checksum).orElse(0L);
    }

    @Override
    public JoinHash get() {
        Optional<JoinFilterFunction> filterFunction = this.filterFunctionFactory.map(factory -> factory.create(this.session.toConnectorSession(), this.addresses, this.pages));
        return new JoinHash(this.pagesHash, filterFunction, this.positionLinks.map(links -> {
            List searchFunctions = (List)this.searchFunctionFactories.stream().map(factory -> factory.create(this.session.toConnectorSession(), this.addresses, this.pages)).collect(ImmutableList.toImmutableList());
            return links.create(searchFunctions);
        }));
    }
}

