/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class PageSourceOperator
implements Operator {
    private final ConnectorPageSource pageSource;
    private final OperatorContext operatorContext;
    private long completedBytes;
    private long readTimeNanos;

    public PageSourceOperator(ConnectorPageSource pageSource, OperatorContext operatorContext) {
        this.pageSource = Objects.requireNonNull(pageSource, "pageSource is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        try {
            this.pageSource.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isFinished() {
        return this.pageSource.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        CompletableFuture pageSourceBlocked = this.pageSource.isBlocked();
        return pageSourceBlocked.isDone() ? NOT_BLOCKED : MoreFutures.toListenableFuture((CompletableFuture)pageSourceBlocked);
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page getOutput() {
        Page page = this.pageSource.getNextPage();
        if (page == null) {
            return null;
        }
        long endCompletedBytes = this.pageSource.getCompletedBytes();
        long endReadTimeNanos = this.pageSource.getReadTimeNanos();
        this.operatorContext.recordPhysicalInputWithTiming(endCompletedBytes - this.completedBytes, page.getPositionCount(), endReadTimeNanos - this.readTimeNanos);
        this.operatorContext.recordProcessedInput(page.getSizeInBytes(), page.getPositionCount());
        this.completedBytes = endCompletedBytes;
        this.readTimeNanos = endReadTimeNanos;
        page = page.getLoadedPage();
        return page;
    }

    @Override
    public void close() throws IOException {
        this.pageSource.close();
    }
}

