/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import io.airlift.stats.QuantileDigest;
import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.ApproximateDoublePercentileAggregations;
import io.trino.operator.aggregation.ApproximateLongPercentileAggregations;
import io.trino.operator.aggregation.FloatingPointBitsConverterUtil;
import io.trino.operator.aggregation.state.QuantileDigestAndPercentileState;
import io.trino.operator.aggregation.state.TDigestAndPercentileState;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;
import io.trino.util.Failures;

@AggregationFunction(value="approx_percentile")
public final class ApproximateRealPercentileAggregations {
    private ApproximateRealPercentileAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestAndPercentileState state, @SqlType(value="real") long value, @SqlType(value="double") double percentile) {
        ApproximateDoublePercentileAggregations.input(state, Float.intBitsToFloat((int)value), percentile);
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestAndPercentileState state, @SqlType(value="real") long value, @SqlType(value="double") double weight, @SqlType(value="double") double percentile) {
        ApproximateDoublePercentileAggregations.weightedInput(state, Float.intBitsToFloat((int)value), weight, percentile);
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestAndPercentileState state, @AggregationState TDigestAndPercentileState otherState) {
        ApproximateDoublePercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState TDigestAndPercentileState state, BlockBuilder out) {
        TDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)digest.valueAt(percentile)));
        }
    }

    @Deprecated
    @Description(value="(DEPRECATED) Use approx_percentile(x, weight, percentile) instead")
    @InputFunction
    public static void weightedInput(@AggregationState QuantileDigestAndPercentileState state, @SqlType(value="real") long value, @SqlType(value="double") double weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.floatToSortableInt(Float.intBitsToFloat((int)value)), weight, percentile, accuracy);
    }

    @CombineFunction
    public static void combine(@AggregationState QuantileDigestAndPercentileState state, @AggregationState QuantileDigestAndPercentileState otherState) {
        ApproximateLongPercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState QuantileDigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits(FloatingPointBitsConverterUtil.sortableIntToFloat((int)digest.getQuantile(percentile))));
        }
    }
}

