/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.minmaxby.LongDoubleState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DoubleType;

@AggregationFunction(value="sum")
public final class DoubleSumAggregation {
    private DoubleSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState LongDoubleState state, @SqlType(value="double") double value) {
        state.setFirst(state.getFirst() + 1L);
        state.setSecond(state.getSecond() + value);
    }

    @RemoveInputFunction
    public static void removeInput(@AggregationState LongDoubleState state, @SqlType(value="double") double value) {
        state.setFirst(state.getFirst() - 1L);
        state.setSecond(state.getSecond() - value);
    }

    @CombineFunction
    public static void combine(@AggregationState LongDoubleState state, @AggregationState LongDoubleState otherState) {
        state.setFirst(state.getFirst() + otherState.getFirst());
        state.setSecond(state.getSecond() + otherState.getSecond());
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState LongDoubleState state, BlockBuilder out) {
        if (state.getFirst() == 0L) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, state.getSecond());
        }
    }
}

