/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.minmaxby.LongLongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.BigintType;
import io.trino.type.BigintOperators;

@AggregationFunction(value="sum")
public final class LongSumAggregation {
    private LongSumAggregation() {
    }

    @InputFunction
    public static void sum(@AggregationState LongLongState state, @SqlType(value="bigint") long value) {
        state.setFirst(state.getFirst() + 1L);
        state.setSecond(BigintOperators.add(state.getSecond(), value));
    }

    @RemoveInputFunction
    public static void removeInput(@AggregationState LongLongState state, @SqlType(value="bigint") long value) {
        state.setFirst(state.getFirst() - 1L);
        state.setSecond(BigintOperators.subtract(state.getSecond(), value));
    }

    @CombineFunction
    public static void combine(@AggregationState LongLongState state, @AggregationState LongLongState otherState) {
        state.setFirst(state.getFirst() + otherState.getFirst());
        state.setSecond(BigintOperators.add(state.getSecond(), otherState.getSecond()));
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongLongState state, BlockBuilder out) {
        if (state.getFirst() == 0L) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getSecond());
        }
    }
}

