/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.NullableLongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;

@AggregationFunction(value="$internal$max_data_size_for_stats", hidden=true)
public final class MaxDataSizeForStats {
    public static final String NAME = "$internal$max_data_size_for_stats";

    private MaxDataSizeForStats() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState NullableLongState state, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        MaxDataSizeForStats.update(state, block.getEstimatedDataSizeForStats(index));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        MaxDataSizeForStats.update(state, otherState.getLong());
    }

    private static void update(NullableLongState state, long size) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(size);
        } else {
            state.setLong(Math.max(state.getLong(), size));
        }
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

