/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlAggregationFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.aggregation.AccumulatorCompiler;
import io.trino.operator.aggregation.AggregationMetadata;
import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.AverageAggregations;
import io.trino.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.state.DoubleState;
import io.trino.operator.aggregation.state.LongState;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class RealAverageAggregation
extends SqlAggregationFunction {
    public static final RealAverageAggregation REAL_AVERAGE_AGGREGATION = new RealAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "input", LongState.class, DoubleState.class, Long.TYPE);
    private static final MethodHandle REMOVE_INPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "removeInput", LongState.class, DoubleState.class, Long.TYPE);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "combine", LongState.class, DoubleState.class, LongState.class, DoubleState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(RealAverageAggregation.class, "output", LongState.class, DoubleState.class, BlockBuilder.class);

    protected RealAverageAggregation() {
        super(new FunctionMetadata(new Signature(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), RealType.REAL.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)RealType.REAL.getTypeSignature()), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, "Returns the average value of the argument", FunctionKind.AGGREGATE), true, false);
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        return ImmutableList.of((Object)StateCompiler.getSerializedType(LongState.class).getTypeSignature(), (Object)StateCompiler.getSerializedType(DoubleState.class).getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding) {
        DynamicClassLoader classLoader = new DynamicClassLoader(AverageAggregations.class.getClassLoader());
        Class<LongState> longStateInterface = LongState.class;
        Class<DoubleState> doubleStateInterface = DoubleState.class;
        AccumulatorStateSerializer<LongState> longStateSerializer = StateCompiler.generateStateSerializer(longStateInterface, classLoader);
        AccumulatorStateSerializer<DoubleState> doubleStateSerializer = StateCompiler.generateStateSerializer(doubleStateInterface, classLoader);
        AggregationMetadata aggregationMetadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, RealType.REAL.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)RealType.REAL.getTypeSignature())), (List<AggregationMetadata.ParameterMetadata>)ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)RealType.REAL)), INPUT_FUNCTION, Optional.of(REMOVE_INPUT_FUNCTION), COMBINE_FUNCTION, OUTPUT_FUNCTION, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(longStateInterface, longStateSerializer, StateCompiler.generateStateFactory(longStateInterface, classLoader)), (Object)new AggregationMetadata.AccumulatorStateDescriptor(doubleStateInterface, doubleStateSerializer, StateCompiler.generateStateFactory(doubleStateInterface, classLoader))), (Type)RealType.REAL);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(aggregationMetadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)ImmutableList.of((Object)RealType.REAL), (List<Type>)ImmutableList.of((Object)longStateSerializer.getSerializedType(), (Object)doubleStateSerializer.getSerializedType()), (Type)RealType.REAL, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type value) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, value), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void input(LongState count, DoubleState sum, long value) {
        count.setLong(count.getLong() + 1L);
        sum.setDouble(sum.getDouble() + (double)Float.intBitsToFloat((int)value));
    }

    public static void removeInput(LongState count, DoubleState sum, long value) {
        count.setLong(count.getLong() - 1L);
        sum.setDouble(sum.getDouble() - (double)Float.intBitsToFloat((int)value));
    }

    public static void combine(LongState count, DoubleState sum, LongState otherCount, DoubleState otherSum) {
        count.setLong(count.getLong() + otherCount.getLong());
        sum.setDouble(sum.getDouble() + otherSum.getDouble());
    }

    public static void output(LongState count, DoubleState sum, BlockBuilder out) {
        if (count.getLong() == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToIntBits((float)(sum.getDouble() / (double)count.getLong())));
        }
    }
}

