/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.AggregationUtils;
import io.trino.operator.aggregation.DoubleCorrelationAggregation;
import io.trino.operator.aggregation.state.CorrelationState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;

@AggregationFunction(value="corr")
public final class RealCorrelationAggregation {
    private RealCorrelationAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CorrelationState state, @SqlType(value="real") long dependentValue, @SqlType(value="real") long independentValue) {
        DoubleCorrelationAggregation.input(state, Float.intBitsToFloat((int)dependentValue), Float.intBitsToFloat((int)independentValue));
    }

    @CombineFunction
    public static void combine(@AggregationState CorrelationState state, @AggregationState CorrelationState otherState) {
        DoubleCorrelationAggregation.combine(state, otherState);
    }

    @OutputFunction(value="real")
    public static void corr(@AggregationState CorrelationState state, BlockBuilder out) {
        double result = AggregationUtils.getCorrelation(state);
        if (Double.isFinite(result)) {
            long resultBits = Float.floatToRawIntBits((float)result);
            RealType.REAL.writeLong(out, resultBits);
        } else {
            out.appendNull();
        }
    }
}

