/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.airlift.stats.TDigest;
import io.trino.operator.aggregation.state.StateCompiler;
import io.trino.operator.aggregation.state.TDigestState;
import io.trino.operator.scalar.TDigestFunctions;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlType;

@AggregationFunction(value="tdigest_agg")
public final class TDigestAggregationFunction {
    private static final AccumulatorStateSerializer<TDigestState> serializer = StateCompiler.generateStateSerializer(TDigestState.class);

    private TDigestAggregationFunction() {
    }

    @InputFunction
    public static void input(@AggregationState TDigestState state, @SqlType(value="double") double value) {
        TDigest tdigest = state.getTDigest();
        if (tdigest == null) {
            tdigest = new TDigest();
            state.setTDigest(tdigest);
            state.addMemoryUsage(tdigest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-tdigest.estimatedInMemorySizeInBytes());
        tdigest.add(value);
        state.addMemoryUsage(tdigest.estimatedInMemorySizeInBytes());
    }

    @InputFunction
    public static void weightedInput(@AggregationState TDigestState state, @SqlType(value="double") double value, @SqlType(value="double") double weight) {
        TDigest tdigest = state.getTDigest();
        if (tdigest == null) {
            tdigest = new TDigest();
            state.setTDigest(tdigest);
            state.addMemoryUsage(tdigest.estimatedInMemorySizeInBytes());
        }
        state.addMemoryUsage(-tdigest.estimatedInMemorySizeInBytes());
        tdigest.add(value, TDigestFunctions.verifyWeight(weight));
        state.addMemoryUsage(tdigest.estimatedInMemorySizeInBytes());
    }

    @CombineFunction
    public static void combine(@AggregationState TDigestState state, @AggregationState TDigestState otherState) {
        TDigest input = otherState.getTDigest();
        if (input == null) {
            return;
        }
        TDigest previous = state.getTDigest();
        if (previous == null) {
            state.setTDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.mergeWith(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    @OutputFunction(value="tdigest")
    public static void output(@AggregationState TDigestState state, BlockBuilder out) {
        serializer.serialize((Object)state, out);
    }
}

