/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxby;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.minmaxby.KeyAndBlockPositionValueState;
import io.trino.spi.block.AbstractRowBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public abstract class KeyAndBlockPositionValueStateSerializer<T extends KeyAndBlockPositionValueState>
implements AccumulatorStateSerializer<T> {
    final Type firstType;
    protected final Type secondType;

    abstract void readFirstField(Block var1, int var2, T var3);

    abstract void writeFirstField(BlockBuilder var1, T var2);

    KeyAndBlockPositionValueStateSerializer(Type firstType, Type secondType) {
        this.firstType = Objects.requireNonNull(firstType, "firstType is null");
        this.secondType = Objects.requireNonNull(secondType, "secondType is null");
    }

    public Type getSerializedType() {
        return RowType.anonymous((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BooleanType.BOOLEAN, (Object)this.firstType, (Object)this.secondType));
    }

    public void serialize(T state, BlockBuilder out) {
        BlockBuilder blockBuilder = out.beginBlockEntry();
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, state.isFirstNull());
        BooleanType.BOOLEAN.writeBoolean(blockBuilder, state.isSecondNull());
        if (state.isFirstNull()) {
            blockBuilder.appendNull();
        } else {
            this.writeFirstField(blockBuilder, state);
        }
        if (state.isSecondNull()) {
            blockBuilder.appendNull();
        } else {
            this.secondType.appendTo(state.getSecondBlock(), state.getSecondPosition(), blockBuilder);
        }
        out.closeEntry();
    }

    public void deserialize(Block block, int index, T state) {
        Preconditions.checkArgument((boolean)(block instanceof AbstractRowBlock));
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
        state.setFirstNull(BooleanType.BOOLEAN.getBoolean(columnarRow.getField(0), index));
        state.setSecondNull(BooleanType.BOOLEAN.getBoolean(columnarRow.getField(1), index));
        if (!state.isFirstNull()) {
            this.readFirstField(columnarRow.getField(2), index, state);
        }
        if (!state.isSecondNull()) {
            state.setSecondPosition(index);
            state.setSecondBlock(columnarRow.getField(3));
        }
    }
}

