/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxby;

import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.TypedKeyValueHeap;
import io.trino.operator.aggregation.minmaxby.MinMaxByNState;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import org.openjdk.jol.info.ClassLayout;

public class MinMaxByNStateFactory
implements AccumulatorStateFactory<MinMaxByNState> {
    public MinMaxByNState createSingleState() {
        return new SingleMinMaxByNState();
    }

    public Class<? extends MinMaxByNState> getSingleStateClass() {
        return SingleMinMaxByNState.class;
    }

    public MinMaxByNState createGroupedState() {
        return new GroupedMinMaxByNState();
    }

    public Class<? extends MinMaxByNState> getGroupedStateClass() {
        return GroupedMinMaxByNState.class;
    }

    public static class SingleMinMaxByNState
    implements MinMaxByNState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMinMaxByNState.class).instanceSize();
        private TypedKeyValueHeap typedKeyValueHeap;

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.typedKeyValueHeap != null) {
                estimatedSize += this.typedKeyValueHeap.getEstimatedSize();
            }
            return estimatedSize;
        }

        @Override
        public TypedKeyValueHeap getTypedKeyValueHeap() {
            return this.typedKeyValueHeap;
        }

        @Override
        public void setTypedKeyValueHeap(TypedKeyValueHeap typedKeyValueHeap) {
            this.typedKeyValueHeap = typedKeyValueHeap;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }
    }

    public static class GroupedMinMaxByNState
    extends AbstractGroupedAccumulatorState
    implements MinMaxByNState {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupedMinMaxByNState.class).instanceSize();
        private final ObjectBigArray<TypedKeyValueHeap> heaps = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.heaps.ensureCapacity(size);
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.heaps.sizeOf() + this.size;
        }

        @Override
        public TypedKeyValueHeap getTypedKeyValueHeap() {
            return (TypedKeyValueHeap)this.heaps.get(this.getGroupId());
        }

        @Override
        public void setTypedKeyValueHeap(TypedKeyValueHeap value) {
            TypedKeyValueHeap previous = this.getTypedKeyValueHeap();
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.heaps.set(this.getGroupId(), (Object)value);
            this.size += value.getEstimatedSize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }
    }
}

