/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.TypedHeap;
import io.trino.operator.aggregation.state.MinMaxNState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import java.util.List;

public class MinMaxNStateSerializer
implements AccumulatorStateSerializer<MinMaxNState> {
    private final BlockTypeOperators.BlockPositionComparison blockComparison;
    private final Type elementType;
    private final ArrayType arrayType;
    private final Type serializedType;

    public MinMaxNStateSerializer(BlockTypeOperators.BlockPositionComparison blockComparison, Type elementType) {
        this.blockComparison = blockComparison;
        this.elementType = elementType;
        this.arrayType = new ArrayType(elementType);
        this.serializedType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)this.arrayType));
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(MinMaxNState state, BlockBuilder out) {
        TypedHeap heap = state.getTypedHeap();
        if (heap == null) {
            out.appendNull();
            return;
        }
        BlockBuilder blockBuilder = out.beginBlockEntry();
        BigintType.BIGINT.writeLong(blockBuilder, (long)heap.getCapacity());
        BlockBuilder elements = blockBuilder.beginBlockEntry();
        heap.writeAll(elements);
        blockBuilder.closeEntry();
        out.closeEntry();
    }

    public void deserialize(Block block, int index, MinMaxNState state) {
        Block currentBlock = (Block)this.serializedType.getObject(block, index);
        int capacity = Math.toIntExact(BigintType.BIGINT.getLong(currentBlock, 0));
        Block heapBlock = this.arrayType.getObject(currentBlock, 1);
        TypedHeap heap = new TypedHeap(this.blockComparison, this.elementType, capacity);
        heap.addAll(heapBlock);
        state.setTypedHeap(heap);
    }
}

