/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.block.Block;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.gen.lambda.BinaryFunctionInterface;
import io.trino.sql.gen.lambda.UnaryFunctionInterface;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ArrayReduceFunction
extends SqlScalarFunction {
    public static final ArrayReduceFunction ARRAY_REDUCE_FUNCTION = new ArrayReduceFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayReduceFunction.class, "reduce", Type.class, Block.class, Object.class, BinaryFunctionInterface.class, UnaryFunctionInterface.class);

    private ArrayReduceFunction() {
        super(new FunctionMetadata(new Signature("reduce", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("S"), (Object)Signature.typeVariable("R")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("R", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (Object)new TypeSignature("S", new TypeSignatureParameter[0]), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("S", new TypeSignatureParameter[0])}), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("R", new TypeSignatureParameter[0])})), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(true), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, false, "Reduce elements of the array into a single value", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type inputType = functionBinding.getTypeVariable("T");
        Type intermediateType = functionBinding.getTypeVariable("S");
        Type outputType = functionBinding.getTypeVariable("R");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(inputType);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Class<?>>)ImmutableList.of(BinaryFunctionInterface.class, UnaryFunctionInterface.class), methodHandle.asType(methodHandle.type().changeParameterType(1, Primitives.wrap((Class)intermediateType.getJavaType())).changeReturnType(Primitives.wrap((Class)outputType.getJavaType()))), Optional.empty());
    }

    public static Object reduce(Type inputType, Block block, Object initialIntermediateValue, BinaryFunctionInterface inputFunction, UnaryFunctionInterface outputFunction) {
        int positionCount = block.getPositionCount();
        Object intermediateValue = initialIntermediateValue;
        for (int position = 0; position < positionCount; ++position) {
            Object input = TypeUtils.readNativeValue((Type)inputType, (Block)block, (int)position);
            intermediateValue = inputFunction.apply(intermediateValue, input);
        }
        return outputFunction.apply(intermediateValue);
    }
}

