/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlOperator;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GenericLessThanOperator
extends SqlOperator {
    private final TypeOperators typeOperators;

    public GenericLessThanOperator(TypeOperators typeOperators) {
        super(OperatorType.LESS_THAN, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("T")), (List<LongVariableConstraint>)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type type = functionBinding.getTypeVariable("T");
        return invocationConvention -> {
            MethodHandle methodHandle = this.typeOperators.getLessThanOperator(type, invocationConvention);
            return new FunctionInvoker(methodHandle, Optional.empty());
        };
    }
}

