/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.operator.scalar.JsonPathTokenizer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.util.JsonUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;

public final class JsonExtract {
    private static final int ESTIMATED_JSON_OUTPUT_SIZE = 512;
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonExtract() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T extract(Slice jsonInput, JsonExtractor<T> jsonExtractor) {
        Objects.requireNonNull(jsonInput, "jsonInput is null");
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JSON_FACTORY, jsonInput);){
            if (jsonParser.nextToken() == null) {
                T t = null;
                return t;
            }
            T t = jsonExtractor.extract(jsonParser);
            return t;
        }
        catch (JsonParseException e) {
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> JsonExtractor<T> generateExtractor(String path, JsonExtractor<T> rootExtractor) {
        return JsonExtract.generateExtractor(path, rootExtractor, false);
    }

    public static <T> JsonExtractor<T> generateExtractor(String path, JsonExtractor<T> rootExtractor, boolean exceptionOnOutOfBounds) {
        ImmutableList tokens = ImmutableList.copyOf((Iterator)((Object)new JsonPathTokenizer(path)));
        JsonExtractor<T> jsonExtractor = rootExtractor;
        for (String token : tokens.reverse()) {
            jsonExtractor = new ObjectFieldJsonExtractor<T>(token, jsonExtractor, exceptionOnOutOfBounds);
        }
        return jsonExtractor;
    }

    private static int tryParseInt(String fieldName, int defaultValue) {
        int index = defaultValue;
        try {
            index = Integer.parseInt(fieldName);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return index;
    }

    public static class JsonSizeExtractor
    implements JsonExtractor<Long> {
        @Override
        public Long extract(JsonParser jsonParser) throws IOException {
            if (!jsonParser.hasCurrentToken()) {
                throw new JsonParseException(jsonParser, "Unexpected end of value");
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                long length = 0L;
                while (true) {
                    JsonToken token;
                    if ((token = jsonParser.nextToken()) == null) {
                        return null;
                    }
                    if (token == JsonToken.END_ARRAY) {
                        return length;
                    }
                    jsonParser.skipChildren();
                    ++length;
                }
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                long length = 0L;
                while (true) {
                    JsonToken token;
                    if ((token = jsonParser.nextToken()) == null) {
                        return null;
                    }
                    if (token == JsonToken.END_OBJECT) {
                        return length;
                    }
                    if (token == JsonToken.FIELD_NAME) {
                        ++length;
                        continue;
                    }
                    jsonParser.skipChildren();
                }
            }
            return 0L;
        }
    }

    public static class JsonValueJsonExtractor
    implements JsonExtractor<Slice> {
        @Override
        public Slice extract(JsonParser jsonParser) throws IOException {
            if (!jsonParser.hasCurrentToken()) {
                throw new JsonParseException(jsonParser, "Unexpected end of value");
            }
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(512);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)dynamicSliceOutput);){
                jsonGenerator.copyCurrentStructure(jsonParser);
            }
            return dynamicSliceOutput.slice();
        }
    }

    public static class ScalarValueJsonExtractor
    implements JsonExtractor<Slice> {
        @Override
        public Slice extract(JsonParser jsonParser) throws IOException {
            JsonToken token = jsonParser.getCurrentToken();
            if (token == null) {
                throw new JsonParseException(jsonParser, "Unexpected end of value");
            }
            if (!token.isScalarValue() || token == JsonToken.VALUE_NULL) {
                return null;
            }
            return Slices.utf8Slice((String)jsonParser.getText());
        }
    }

    public static class ObjectFieldJsonExtractor<T>
    implements JsonExtractor<T> {
        private final SerializedString fieldName;
        private final JsonExtractor<? extends T> delegate;
        private final int index;
        private final boolean exceptionOnOutOfBounds;

        public ObjectFieldJsonExtractor(String fieldName, JsonExtractor<? extends T> delegate) {
            this(fieldName, delegate, false);
        }

        public ObjectFieldJsonExtractor(String fieldName, JsonExtractor<? extends T> delegate, boolean exceptionOnOutOfBounds) {
            this.fieldName = new SerializedString(Objects.requireNonNull(fieldName, "fieldName is null"));
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.exceptionOnOutOfBounds = exceptionOnOutOfBounds;
            this.index = JsonExtract.tryParseInt(fieldName, -1);
        }

        @Override
        public T extract(JsonParser jsonParser) throws IOException {
            if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
                return this.processJsonObject(jsonParser);
            }
            if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
                return this.processJsonArray(jsonParser);
            }
            throw new JsonParseException(jsonParser, "Expected a JSON object or array");
        }

        public T processJsonObject(JsonParser jsonParser) throws IOException {
            while (!jsonParser.nextFieldName((SerializableString)this.fieldName)) {
                if (!jsonParser.hasCurrentToken()) {
                    throw new JsonParseException(jsonParser, "Unexpected end of object");
                }
                if (jsonParser.getCurrentToken() == JsonToken.END_OBJECT) {
                    return null;
                }
                jsonParser.skipChildren();
            }
            jsonParser.nextToken();
            return this.delegate.extract(jsonParser);
        }

        public T processJsonArray(JsonParser jsonParser) throws IOException {
            int currentIndex = 0;
            while (true) {
                JsonToken token;
                if ((token = jsonParser.nextToken()) == null) {
                    throw new JsonParseException(jsonParser, "Unexpected end of array");
                }
                if (token == JsonToken.END_ARRAY) {
                    if (this.exceptionOnOutOfBounds) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Index out of bounds");
                    }
                    return null;
                }
                if (currentIndex == this.index) break;
                ++currentIndex;
                jsonParser.skipChildren();
            }
            return this.delegate.extract(jsonParser);
        }
    }

    public static interface JsonExtractor<T> {
        public T extract(JsonParser var1) throws IOException;
    }
}

