/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.FunctionArgumentDefinition;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionKind;
import io.trino.metadata.FunctionMetadata;
import io.trino.metadata.LongVariableConstraint;
import io.trino.metadata.Signature;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TypeVariableConstraint;
import io.trino.operator.scalar.ChoicesScalarFunctionImplementation;
import io.trino.operator.scalar.ScalarFunctionImplementation;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class VersionFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(VersionFunction.class, "getVersion", String.class);
    private final String nodeVersion;

    public VersionFunction(String nodeVersion) {
        super(new FunctionMetadata(new Signature("version", (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), VarcharType.VARCHAR.getTypeSignature(), (List<TypeSignature>)ImmutableList.of(), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of(), true, true, "Return server version", FunctionKind.SCALAR));
        this.nodeVersion = nodeVersion;
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.nodeVersion);
        return new ChoicesScalarFunctionImplementation(functionBinding, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of(), methodHandle);
    }

    @UsedByGeneratedCode
    public static Slice getVersion(String version) {
        return Slices.utf8Slice((String)version);
    }
}

