/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.PagesHashStrategy;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.FrameInfo;
import io.trino.operator.window.FramedWindowFunction;
import io.trino.operator.window.Framing;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.operator.window.RowsFraming;
import io.trino.operator.window.WindowPartition;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.MatchResult;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.operator.window.pattern.LogicalIndexNavigation;
import io.trino.operator.window.pattern.MeasureComputation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.function.WindowIndex;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.SkipTo;
import java.util.List;
import java.util.Optional;

public final class PatternRecognitionPartition
implements WindowPartition {
    private final PagesIndex pagesIndex;
    private final WindowIndex windowIndex;
    private final int partitionStart;
    private final int partitionEnd;
    private final int[] outputChannels;
    private final List<FramedWindowFunction> windowFunctions;
    private final PagesHashStrategy peerGroupHashStrategy;
    private int peerGroupStart;
    private int peerGroupEnd;
    private int currentPosition;
    private final List<MeasureComputation> measures;
    private final Optional<RowsFraming> framing;
    private final PatternRecognitionRelation.RowsPerMatch rowsPerMatch;
    private final Optional<LogicalIndexNavigation> skipToNavigation;
    private final SkipTo.Position skipToPosition;
    private final boolean initial;
    private final Matcher matcher;
    private final List<LabelEvaluator.Evaluation> labelEvaluations;
    private int lastSkippedPosition;
    private int lastMatchedPosition;
    private long matchNumber;

    public PatternRecognitionPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<FramedWindowFunction> windowFunctions, PagesHashStrategy peerGroupHashStrategy, List<MeasureComputation> measures, Optional<FrameInfo> commonBaseFrame, PatternRecognitionRelation.RowsPerMatch rowsPerMatch, Optional<LogicalIndexNavigation> skipToNavigation, SkipTo.Position skipToPosition, boolean initial, Matcher matcher, List<LabelEvaluator.Evaluation> labelEvaluations) {
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.outputChannels = outputChannels;
        this.windowFunctions = ImmutableList.copyOf(windowFunctions);
        this.peerGroupHashStrategy = peerGroupHashStrategy;
        this.measures = ImmutableList.copyOf(measures);
        this.framing = commonBaseFrame.map(frameInfo -> new RowsFraming((FrameInfo)frameInfo, partitionStart, partitionEnd, pagesIndex));
        this.rowsPerMatch = rowsPerMatch;
        this.skipToNavigation = skipToNavigation;
        this.skipToPosition = skipToPosition;
        this.initial = initial;
        this.matcher = matcher;
        this.labelEvaluations = ImmutableList.copyOf(labelEvaluations);
        this.lastSkippedPosition = partitionStart - 1;
        this.lastMatchedPosition = partitionStart - 1;
        this.matchNumber = 1L;
        this.windowIndex = new PagesWindowIndex(pagesIndex, partitionStart, partitionEnd);
        for (FramedWindowFunction framedWindowFunction : windowFunctions) {
            framedWindowFunction.getFunction().reset(this.windowIndex);
        }
        this.currentPosition = partitionStart;
        this.updatePeerGroup();
    }

    @Override
    public int getPartitionStart() {
        return this.partitionStart;
    }

    @Override
    public int getPartitionEnd() {
        return this.partitionEnd;
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    @Override
    public void processNextRow(PageBuilder pageBuilder) {
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more rows in partition");
        if (this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        if (this.isSkipped(this.currentPosition)) {
            if (this.rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.WINDOW) {
                this.outputUnmatchedRow(pageBuilder);
            }
        } else {
            int searchStart = this.partitionStart;
            int searchEnd = this.partitionEnd;
            int patternStart = this.currentPosition;
            if (this.framing.isPresent()) {
                Framing.Range baseRange = this.framing.get().getRange(this.currentPosition, -1, this.peerGroupStart, this.peerGroupEnd);
                searchStart = baseRange.getStart();
                searchEnd = baseRange.getEnd();
            }
            LabelEvaluator labelEvaluator = new LabelEvaluator(this.matchNumber, patternStart, searchStart, searchEnd, this.labelEvaluations, this.windowIndex);
            MatchResult matchResult = this.matcher.run(labelEvaluator);
            while (!matchResult.isMatched() && !this.initial && patternStart < searchEnd - 1) {
                labelEvaluator = new LabelEvaluator(this.matchNumber, ++patternStart, searchStart, searchEnd, this.labelEvaluations, this.windowIndex);
                matchResult = this.matcher.run(labelEvaluator);
            }
            if (!matchResult.isMatched()) {
                if (this.rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.WINDOW || this.rowsPerMatch.isUnmatchedRows() && !this.isMatched(this.currentPosition)) {
                    this.outputUnmatchedRow(pageBuilder);
                }
                this.lastSkippedPosition = this.currentPosition;
            } else if (matchResult.getLabels().length() == 0) {
                if (this.rowsPerMatch.isEmptyMatches()) {
                    this.outputEmptyMatch(pageBuilder);
                }
                this.lastSkippedPosition = this.currentPosition;
                ++this.matchNumber;
            } else {
                if (this.rowsPerMatch.isOneRow()) {
                    this.outputOneRowPerMatch(pageBuilder, matchResult, patternStart, searchStart, searchEnd);
                } else {
                    this.outputAllRowsPerMatch(pageBuilder, matchResult);
                }
                this.updateLastMatchedPosition(matchResult, patternStart);
                this.skipAfterMatch(matchResult, patternStart, searchStart, searchEnd);
                ++this.matchNumber;
            }
        }
        ++this.currentPosition;
    }

    private boolean isSkipped(int position) {
        return position <= this.lastSkippedPosition;
    }

    private boolean isMatched(int position) {
        return position <= this.lastMatchedPosition;
    }

    private void outputUnmatchedRow(PageBuilder pageBuilder) {
        int channel;
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        for (int i = 0; i < this.measures.size(); ++i) {
            pageBuilder.getBlockBuilder(channel).appendNull();
            ++channel;
        }
        for (FramedWindowFunction framedFunction : this.windowFunctions) {
            Framing.Range range = new Framing.Range(-1, -1);
            framedFunction.getFunction().processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, range.getStart(), range.getEnd());
            ++channel;
        }
    }

    private void outputEmptyMatch(PageBuilder pageBuilder) {
        int channel;
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        for (MeasureComputation measureComputation : this.measures) {
            Block result = measureComputation.computeEmpty(this.matchNumber);
            measureComputation.getType().appendTo(result, 0, pageBuilder.getBlockBuilder(channel));
            ++channel;
        }
        for (FramedWindowFunction framedFunction : this.windowFunctions) {
            Framing.Range range = new Framing.Range(-1, -1);
            framedFunction.getFunction().processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, range.getStart(), range.getEnd());
            ++channel;
        }
    }

    private void outputOneRowPerMatch(PageBuilder pageBuilder, MatchResult matchResult, int patternStart, int searchStart, int searchEnd) {
        int channel;
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        ArrayView labels = matchResult.getLabels();
        for (MeasureComputation measureComputation : this.measures) {
            Block result = measureComputation.compute(patternStart + labels.length() - 1, labels, searchStart, searchEnd, patternStart, this.matchNumber, this.windowIndex);
            measureComputation.getType().appendTo(result, 0, pageBuilder.getBlockBuilder(channel));
            ++channel;
        }
        for (FramedWindowFunction framedFunction : this.windowFunctions) {
            framedFunction.getFunction().processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, patternStart - this.partitionStart, patternStart + labels.length() - 1 - this.partitionStart);
            ++channel;
        }
    }

    private void outputAllRowsPerMatch(PageBuilder pageBuilder, MatchResult matchResult) {
        Preconditions.checkState((boolean)this.windowFunctions.isEmpty(), (Object)"invalid node: window functions specified with ALL ROWS PER MATCH");
        ArrayView labels = matchResult.getLabels();
        ArrayView exclusions = matchResult.getExclusions();
        int start = 0;
        for (int index = 0; index < exclusions.length(); index += 2) {
            int end = exclusions.get(index);
            for (int i = start; i < end; ++i) {
                this.outputRow(pageBuilder, labels, this.currentPosition + i);
            }
            start = exclusions.get(index + 1);
        }
        for (int i = start; i < labels.length(); ++i) {
            this.outputRow(pageBuilder, labels, this.currentPosition + i);
        }
    }

    private void outputRow(PageBuilder pageBuilder, ArrayView labels, int position) {
        int channel;
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], position, pageBuilder.getBlockBuilder(channel));
        }
        for (MeasureComputation measureComputation : this.measures) {
            Block result = measureComputation.compute(position, labels, this.partitionStart, this.partitionEnd, this.currentPosition, this.matchNumber, this.windowIndex);
            measureComputation.getType().appendTo(result, 0, pageBuilder.getBlockBuilder(channel));
            ++channel;
        }
    }

    private void updateLastMatchedPosition(MatchResult matchResult, int patternStart) {
        int lastPositionInMatch = patternStart + matchResult.getLabels().length() - 1;
        this.lastMatchedPosition = Math.max(this.lastMatchedPosition, lastPositionInMatch);
    }

    private void skipAfterMatch(MatchResult matchResult, int patternStart, int searchStart, int searchEnd) {
        ArrayView labels = matchResult.getLabels();
        switch (this.skipToPosition) {
            case PAST_LAST: {
                this.lastSkippedPosition = patternStart + labels.length() - 1;
                break;
            }
            case NEXT: {
                this.lastSkippedPosition = this.currentPosition;
                break;
            }
            case LAST: 
            case FIRST: {
                Preconditions.checkState((boolean)this.skipToNavigation.isPresent(), (String)"skip to navigation is missing for SKIP TO ", (Object)this.skipToPosition.name());
                int position = this.skipToNavigation.get().resolvePosition(patternStart + labels.length() - 1, labels, searchStart, searchEnd, patternStart);
                if (position == -1) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "AFTER MATCH SKIP failed: pattern variable is not present in match");
                }
                if (position == patternStart) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "AFTER MATCH SKIP failed: cannot skip to first row of match");
                }
                this.lastSkippedPosition = position - 1;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected SKIP TO position: " + this.skipToPosition);
            }
        }
    }

    private void updatePeerGroup() {
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.pagesIndex.positionNotDistinctFromPosition(this.peerGroupHashStrategy, this.peerGroupStart, this.peerGroupEnd)) {
            ++this.peerGroupEnd;
        }
    }
}

