/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.base.Preconditions;
import io.trino.operator.window.matcher.Captures;
import io.trino.operator.window.matcher.Instruction;
import io.trino.operator.window.matcher.IntList;
import io.trino.operator.window.matcher.IntStack;
import io.trino.operator.window.matcher.Jump;
import io.trino.operator.window.matcher.MatchLabel;
import io.trino.operator.window.matcher.MatchResult;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.matcher.Split;
import io.trino.operator.window.pattern.LabelEvaluator;

public class Matcher {
    private final Program program;

    public Matcher(Program program) {
        this.program = program;
    }

    public MatchResult run(LabelEvaluator labelEvaluator) {
        IntList current = new IntList(this.program.size());
        IntList next = new IntList(this.program.size());
        int inputLength = labelEvaluator.getInputLength();
        boolean matchingAtPartitionStart = labelEvaluator.isMatchingAtPartitionStart();
        Runtime runtime = new Runtime(this.program, inputLength, matchingAtPartitionStart);
        runtime.nextStep();
        this.advanceAndSchedule(current, runtime.newThread(), 0, 0, runtime);
        MatchResult result = MatchResult.NO_MATCH;
        for (int index = 0; index < inputLength && current.size() != 0; ++index) {
            Preconditions.checkState((boolean)runtime.hasCapacity(current.size()), (Object)"thread capacity insufficient");
            runtime.nextStep();
            boolean matched = false;
            for (int i = 0; i < current.size(); ++i) {
                int threadId = current.get(i);
                int pointer = runtime.threads[threadId];
                Instruction instruction = this.program.at(pointer);
                switch (instruction.type()) {
                    case MATCH_LABEL: {
                        int label = ((MatchLabel)instruction).getLabel();
                        if (labelEvaluator.evaluateLabel(label, runtime.captures.getLabels(threadId))) {
                            runtime.captures.saveLabel(threadId, label);
                            this.advanceAndSchedule(next, threadId, pointer + 1, index + 1, runtime);
                            break;
                        }
                        runtime.killThread(threadId);
                        break;
                    }
                    case DONE: {
                        matched = true;
                        result = new MatchResult(true, runtime.captures.getLabels(threadId), runtime.captures.getCaptures(threadId));
                        runtime.killThread(threadId);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("not yet implemented");
                    }
                }
                if (!matched) continue;
                for (int j = i + 1; j < current.size(); ++j) {
                    runtime.killThread(current.get(j));
                }
                break;
            }
            IntList temp = current;
            temp.clear();
            current = next;
            next = temp;
        }
        for (int i = 0; i < current.size(); ++i) {
            int threadId = current.get(i);
            if (this.program.at(runtime.threads[threadId]).type() != Instruction.Type.DONE) continue;
            result = new MatchResult(true, runtime.captures.getLabels(threadId), runtime.captures.getCaptures(threadId));
            break;
        }
        return result;
    }

    private void advanceAndSchedule(IntList next, int threadId, int pointer, int inputIndex, Runtime runtime) {
        if (runtime.steps[pointer] == runtime.step) {
            runtime.killThread(threadId);
            return;
        }
        runtime.steps[pointer] = runtime.step;
        Instruction instruction = this.program.at(pointer);
        switch (instruction.type()) {
            case MATCH_START: {
                if (inputIndex == 0 && runtime.matchingAtPartitionStart) {
                    this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                    break;
                }
                runtime.killThread(threadId);
                break;
            }
            case MATCH_END: {
                if (inputIndex == runtime.inputLength) {
                    this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                    break;
                }
                runtime.killThread(threadId);
                break;
            }
            case JUMP: {
                this.advanceAndSchedule(next, threadId, ((Jump)instruction).getTarget(), inputIndex, runtime);
                break;
            }
            case SPLIT: {
                int forked = runtime.forkThread(threadId);
                this.advanceAndSchedule(next, threadId, ((Split)instruction).getFirst(), inputIndex, runtime);
                this.advanceAndSchedule(next, forked, ((Split)instruction).getSecond(), inputIndex, runtime);
                break;
            }
            case SAVE: {
                runtime.captures.save(threadId, inputIndex);
                this.advanceAndSchedule(next, threadId, pointer + 1, inputIndex, runtime);
                break;
            }
            default: {
                runtime.threads[threadId] = pointer;
                next.add(threadId);
            }
        }
    }

    private static class Runtime {
        private int step;
        private final int[] threads;
        private final IntStack freeThreadIds;
        private final int inputLength;
        private final boolean matchingAtPartitionStart;
        private final Captures captures;
        private final int[] steps;

        public Runtime(Program program, int inputLength, boolean matchingAtPartitionStart) {
            int size = program.size();
            this.threads = new int[2 * size];
            this.freeThreadIds = new IntStack(this.threads.length);
            for (int i = this.threads.length - 1; i >= 0; --i) {
                this.freeThreadIds.push(i);
            }
            this.captures = new Captures(this.threads.length, program.getMinSlotCount(), program.getMinLabelCount());
            this.inputLength = inputLength;
            this.steps = new int[size];
            this.matchingAtPartitionStart = matchingAtPartitionStart;
        }

        public void nextStep() {
            ++this.step;
        }

        public boolean hasCapacity(int size) {
            return this.freeThreadIds.size() >= size;
        }

        private int forkThread(int parent) {
            int threadId = this.freeThreadIds.pop();
            this.captures.copy(parent, threadId);
            return threadId;
        }

        private int newThread() {
            int threadId = this.freeThreadIds.pop();
            this.captures.allocate(threadId);
            return threadId;
        }

        private void killThread(int threadId) {
            this.freeThreadIds.push(threadId);
            this.captures.release(threadId);
        }
    }
}

