/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.hash.Hashing;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.trino.server.InternalCommunicationConfig;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.security.InternalPrincipal;
import io.trino.spi.security.Identity;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class InternalAuthenticationManager
implements HttpRequestFilter {
    private static final Logger log = Logger.get(InternalAuthenticationManager.class);
    private static final String TRINO_INTERNAL_BEARER = "X-Trino-Internal-Bearer";
    private final byte[] hmac;
    private final String nodeId;

    @Inject
    public InternalAuthenticationManager(InternalCommunicationConfig internalCommunicationConfig, NodeInfo nodeInfo) {
        this(InternalAuthenticationManager.getSharedSecret(internalCommunicationConfig, nodeInfo), nodeInfo.getNodeId());
    }

    private static String getSharedSecret(InternalCommunicationConfig internalCommunicationConfig, NodeInfo nodeInfo) {
        Objects.requireNonNull(internalCommunicationConfig, "internalCommunicationConfig is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        if (!internalCommunicationConfig.isRequiredSharedSecretSet()) {
            throw new IllegalArgumentException("Shared secret is required when internal communications uses https");
        }
        return internalCommunicationConfig.getSharedSecret().orElseGet(() -> ((NodeInfo)nodeInfo).getEnvironment());
    }

    public InternalAuthenticationManager(String sharedSecret, String nodeId) {
        Objects.requireNonNull(sharedSecret, "sharedSecret is null");
        Objects.requireNonNull(nodeId, "nodeId is null");
        this.hmac = Hashing.sha256().hashString((CharSequence)sharedSecret, StandardCharsets.UTF_8).asBytes();
        this.nodeId = nodeId;
    }

    public static boolean isInternalRequest(ContainerRequestContext request) {
        return request.getHeaders().getFirst((Object)TRINO_INTERNAL_BEARER) != null;
    }

    public void handleInternalRequest(ContainerRequestContext request) {
        String subject;
        try {
            subject = this.parseJwt((String)request.getHeaders().getFirst((Object)TRINO_INTERNAL_BEARER));
        }
        catch (JwtException e) {
            log.error((Throwable)e, "Internal authentication failed");
            request.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.TEXT_PLAIN_TYPE.toString()).build());
            return;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
        Identity identity = Identity.forUser((String)"<internal>").withPrincipal((Principal)new InternalPrincipal(subject)).build();
        ServletSecurityUtils.setAuthenticatedIdentity(request, identity);
    }

    public Request filterRequest(Request request) {
        return Request.Builder.fromRequest((Request)request).addHeader(TRINO_INTERNAL_BEARER, this.generateJwt()).build();
    }

    private String generateJwt() {
        return Jwts.builder().signWith(SignatureAlgorithm.HS256, this.hmac).setSubject(this.nodeId).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
    }

    private String parseJwt(String jwt) {
        return ((Claims)Jwts.parser().setSigningKey(this.hmac).parseClaimsJws(jwt).getBody()).getSubject();
    }
}

