/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.jwt.JwtAuthenticatorConfig;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class JwtAuthenticator
extends AbstractBearerAuthenticator {
    private final JwtParser jwtParser;

    @Inject
    public JwtAuthenticator(JwtAuthenticatorConfig config, SigningKeyResolver signingKeyResolver) {
        super(config.getPrincipalField(), UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile()));
        JwtParser jwtParser = Jwts.parser().setSigningKeyResolver(signingKeyResolver);
        if (config.getRequiredIssuer() != null) {
            jwtParser.requireIssuer(config.getRequiredIssuer());
        }
        if (config.getRequiredAudience() != null) {
            jwtParser.requireAudience(config.getRequiredAudience());
        }
        this.jwtParser = jwtParser;
    }

    @Override
    protected Jws<Claims> parseClaimsJws(String jws) {
        return this.jwtParser.parseClaimsJws(jws);
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        return new AuthenticationException(message, "Bearer realm=\"Trino\", token_type=\"JWT\"");
    }
}

