/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.trino.server.security.AbstractBearerAuthenticator;
import io.trino.server.security.AuthenticationException;
import io.trino.server.security.UserMapping;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchangeResource;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;

public class OAuth2Authenticator
extends AbstractBearerAuthenticator {
    private final OAuth2Service service;

    @Inject
    public OAuth2Authenticator(OAuth2Service service, OAuth2Config config) {
        super(config.getPrincipalField(), UserMapping.createUserMapping(config.getUserMappingPattern(), config.getUserMappingFile()));
        this.service = Objects.requireNonNull(service, "service is null");
    }

    @Override
    protected Jws<Claims> parseClaimsJws(String jws) {
        return this.service.parseClaimsJws(jws);
    }

    @Override
    protected AuthenticationException needAuthentication(ContainerRequestContext request, String message) {
        UUID authId = UUID.randomUUID();
        URI redirectUri = this.service.startRestChallenge(request.getUriInfo().getBaseUri().resolve("/oauth2/callback"), authId);
        URI tokenUri = request.getUriInfo().getBaseUri().resolve(OAuth2TokenExchangeResource.getTokenUri(authId));
        return new AuthenticationException(message, String.format("Bearer x_redirect_server=\"%s\", x_token_server=\"%s\"", redirectUri, tokenUri));
    }
}

