/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.ui;

import io.airlift.log.Logger;
import io.trino.server.security.PasswordAuthenticatorManager;
import io.trino.server.security.SecurityConfig;
import io.trino.server.ui.FormAuthenticator;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.PasswordAuthenticator;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class PasswordManagerFormAuthenticator
implements FormAuthenticator {
    private static final Logger log = Logger.get(PasswordManagerFormAuthenticator.class);
    private final PasswordAuthenticatorManager passwordAuthenticatorManager;
    private final boolean insecureAuthenticationOverHttpAllowed;

    @Inject
    public PasswordManagerFormAuthenticator(PasswordAuthenticatorManager passwordAuthenticatorManager, SecurityConfig securityConfig) {
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        passwordAuthenticatorManager.setRequired();
        this.insecureAuthenticationOverHttpAllowed = Objects.requireNonNull(securityConfig, "securityConfig is null").isInsecureAuthenticationOverHttpAllowed();
    }

    @Override
    public boolean isLoginEnabled(boolean secure) {
        if (secure) {
            return true;
        }
        return this.insecureAuthenticationOverHttpAllowed;
    }

    @Override
    public boolean isPasswordAllowed(boolean secure) {
        return secure;
    }

    @Override
    public boolean isValidCredential(String username, String password, boolean secure) {
        if (username == null) {
            return false;
        }
        if (!secure) {
            return this.insecureAuthenticationOverHttpAllowed && password == null;
        }
        List<PasswordAuthenticator> authenticators = this.passwordAuthenticatorManager.getAuthenticators();
        for (PasswordAuthenticator authenticator : authenticators) {
            try {
                authenticator.createAuthenticatedPrincipal(username, password);
                return true;
            }
            catch (AccessDeniedException accessDeniedException) {
            }
            catch (RuntimeException e) {
                log.debug((Throwable)e, "Error authenticating user for Web UI");
            }
        }
        return false;
    }
}

