/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.connector.CatalogName;
import io.trino.execution.Lifespan;
import io.trino.metadata.Split;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.split.SplitSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class BufferingSplitSource
implements SplitSource {
    private final int bufferSize;
    private final SplitSource source;

    public BufferingSplitSource(SplitSource source, int bufferSize) {
        this.source = Objects.requireNonNull(source, "source is null");
        this.bufferSize = bufferSize;
    }

    @Override
    public CatalogName getCatalogName() {
        return this.source.getCatalogName();
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, Lifespan lifespan, int maxSize) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"Cannot fetch a batch of zero size");
        return GetNextBatch.fetchNextBatchAsync(this.source, Math.min(this.bufferSize, maxSize), maxSize, partitionHandle, lifespan);
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    private static class GetNextBatch {
        private final SplitSource splitSource;
        private final int min;
        private final int max;
        private final ConnectorPartitionHandle partitionHandle;
        private final Lifespan lifespan;
        private final List<Split> splits = new ArrayList<Split>();
        private boolean noMoreSplits;

        public static ListenableFuture<SplitSource.SplitBatch> fetchNextBatchAsync(SplitSource splitSource, int min, int max, ConnectorPartitionHandle partitionHandle, Lifespan lifespan) {
            GetNextBatch getNextBatch = new GetNextBatch(splitSource, min, max, partitionHandle, lifespan);
            ListenableFuture<?> future = getNextBatch.fetchSplits();
            return Futures.transform(future, ignored -> new SplitSource.SplitBatch(getNextBatch.splits, getNextBatch.noMoreSplits), (Executor)MoreExecutors.directExecutor());
        }

        private GetNextBatch(SplitSource splitSource, int min, int max, ConnectorPartitionHandle partitionHandle, Lifespan lifespan) {
            this.splitSource = Objects.requireNonNull(splitSource, "splitSource is null");
            Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"Min splits greater than max splits");
            this.min = min;
            this.max = max;
            this.partitionHandle = Objects.requireNonNull(partitionHandle, "partitionHandle is null");
            this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
        }

        private ListenableFuture<?> fetchSplits() {
            if (this.splits.size() >= this.min) {
                return Futures.immediateFuture(null);
            }
            ListenableFuture<SplitSource.SplitBatch> future = this.splitSource.getNextBatch(this.partitionHandle, this.lifespan, this.max - this.splits.size());
            return Futures.transformAsync(future, splitBatch -> {
                this.splits.addAll(splitBatch.getSplits());
                if (splitBatch.isLastBatch()) {
                    this.noMoreSplits = true;
                    return Futures.immediateFuture(null);
                }
                return this.fetchSplits();
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

