/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.util.AstUtils;
import java.util.Objects;
import java.util.OptionalInt;

public class CanonicalizationAware<T extends Node> {
    private final T node;

    private CanonicalizationAware(T node) {
        this.node = (Node)Objects.requireNonNull(node, "node is null");
    }

    public static <T extends Node> CanonicalizationAware<T> canonicalizationAwareKey(T node) {
        return new CanonicalizationAware<T>(node);
    }

    public T getNode() {
        return this.node;
    }

    public int hashCode() {
        return AstUtils.treeHash(this.node, CanonicalizationAware::canonicalizationAwareHash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalizationAware other = (CanonicalizationAware)o;
        return AstUtils.treeEqual(this.node, other.node, CanonicalizationAware::canonicalizationAwareComparison);
    }

    public String toString() {
        return "CanonicalizationAware(" + this.node + ")";
    }

    public static Boolean canonicalizationAwareComparison(Node left, Node right) {
        if (left instanceof Identifier && right instanceof Identifier) {
            Identifier leftIdentifier = (Identifier)left;
            Identifier rightIdentifier = (Identifier)right;
            return leftIdentifier.getCanonicalValue().equals(rightIdentifier.getCanonicalValue());
        }
        return null;
    }

    public static OptionalInt canonicalizationAwareHash(Node node) {
        if (node instanceof Identifier) {
            return OptionalInt.of(((Identifier)node).getCanonicalValue().hashCode());
        }
        if (node.getChildren().isEmpty()) {
            return OptionalInt.of(node.hashCode());
        }
        return OptionalInt.empty();
    }
}

