/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.ParameterUtils;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.planprinter.IoPlanPrinter;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final Metadata metadata;
    private final TypeOperators typeOperators;
    private final GroupProvider groupProvider;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask;

    @Inject
    public QueryExplainer(PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, Metadata metadata, TypeOperators typeOperators, GroupProvider groupProvider, AccessControl accessControl, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask) {
        this(planOptimizersFactory.get(), planFragmenter, metadata, typeOperators, groupProvider, accessControl, sqlParser, statsCalculator, costCalculator, dataDefinitionTask);
    }

    public QueryExplainer(List<PlanOptimizer> planOptimizers, PlanFragmenter planFragmenter, Metadata metadata, TypeOperators typeOperators, GroupProvider groupProvider, AccessControl accessControl, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, Map<Class<? extends Statement>, DataDefinitionTask<?>> dataDefinitionTask) {
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.dataDefinitionTask = ImmutableMap.copyOf(Objects.requireNonNull(dataDefinitionTask, "dataDefinitionTask is null"));
    }

    public Analysis analyze(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analyzer analyzer = new Analyzer(session, this.metadata, this.sqlParser, this.groupProvider, this.accessControl, Optional.of(this), parameters, ParameterUtils.parameterExtractor(statement, parameters), warningCollector, this.statsCalculator);
        return analyzer.analyze(statement);
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textLogicalPlan(plan.getRoot(), plan.getTypes(), this.metadata, plan.getStatsAndCosts(), session, 0, false);
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.textDistributedPlan(subPlan, this.metadata, session, false);
            }
            case IO: {
                return IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector), this.metadata, this.typeOperators, session);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    private static <T extends Statement> String explainTask(Statement statement, DataDefinitionTask<T> task, List<Expression> parameters) {
        return task.explain(statement, parameters);
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case LOGICAL: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizLogicalPlan(plan.getRoot(), plan.getTypes());
            }
            case DISTRIBUTED: {
                SubPlan subPlan = this.getDistributedPlan(session, statement, parameters, warningCollector);
                return PlanPrinter.graphvizDistributedPlan(subPlan);
            }
        }
        throw new IllegalArgumentException("Unhandled plan type: " + planType);
    }

    public String getJsonPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector) {
        DataDefinitionTask<?> task = this.dataDefinitionTask.get(statement.getClass());
        if (task != null) {
            return QueryExplainer.explainTask(statement, task, parameters);
        }
        switch (planType) {
            case IO: {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
                return IoPlanPrinter.textIoPlan(plan, this.metadata, this.typeOperators, session);
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported explain plan type %s for JSON format", planType));
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Analysis analysis = this.analyze(session, statement, parameters, warningCollector);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.metadata, this.typeOperators, new TypeAnalyzer(this.sqlParser, this.metadata), this.statsCalculator, this.costCalculator, warningCollector);
        return logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, true);
    }

    private SubPlan getDistributedPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector) {
        Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector);
        return this.planFragmenter.createSubPlans(session, plan, false, warningCollector);
    }
}

