/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.control.WhileLoop;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.JumpInstruction;
import io.airlift.bytecode.instruction.LabelNode;
import io.airlift.slice.Slice;
import io.trino.metadata.Metadata;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.CursorProcessorOutput;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BodyCompiler;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import io.trino.sql.gen.LambdaBytecodeGenerator;
import io.trino.sql.gen.LambdaExpressionExtractor;
import io.trino.sql.gen.RowExpressionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.ConstantExpression;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.RowExpressionVisitor;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import java.util.List;
import java.util.Map;

public class CursorProcessorCompiler
implements BodyCompiler {
    private final Metadata metadata;

    public CursorProcessorCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, List<RowExpression> projections) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        CursorProcessorCompiler.generateProcessMethod(classDefinition, projections.size());
        Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> filterCompiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, filter, "filter");
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, filterCompiledLambdaMap, filter);
        for (int i = 0; i < projections.size(); ++i) {
            String methodName = "project_" + i;
            Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> projectCompiledLambdaMap = this.generateMethodsForLambda(classDefinition, callSiteBinder, cachedInstanceBinder, projections.get(i), methodName);
            this.generateProjectMethod(classDefinition, callSiteBinder, cachedInstanceBinder, projectCompiledLambdaMap, methodName, projections.get(i));
        }
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
    }

    private static void generateProcessMethod(ClassDefinition classDefinition, int projections) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter yieldSignal = Parameter.arg((String)"yieldSignal", DriverYieldSignal.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter pageBuilder = Parameter.arg((String)"pageBuilder", PageBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "process", ParameterizedType.type(CursorProcessorOutput.class), new Parameter[]{session, yieldSignal, cursor, pageBuilder});
        Scope scope = method.getScope();
        Variable completedPositionsVariable = scope.declareVariable(Integer.TYPE, "completedPositions");
        Variable finishedVariable = scope.declareVariable(Boolean.TYPE, "finished");
        method.getBody().comment("int completedPositions = 0;").putVariable(completedPositionsVariable, 0).comment("boolean finished = false;").putVariable(finishedVariable, false);
        LabelNode done = new LabelNode("done");
        WhileLoop whileLoop = new WhileLoop().condition((BytecodeNode)BytecodeExpressions.constantTrue()).body((BytecodeNode)new BytecodeBlock().comment("if (pageBuilder.isFull() || yieldSignal.isSet()) return new CursorProcessorOutput(completedPositions, false);").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.or((BytecodeExpression)pageBuilder.invoke("isFull", Boolean.TYPE, new BytecodeExpression[0]), (BytecodeExpression)yieldSignal.invoke("isSet", Boolean.TYPE, new BytecodeExpression[0]))).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)done))).comment("if (!cursor.advanceNextPosition()) return new CursorProcessorOutput(completedPositions, true);").append((BytecodeNode)new IfStatement().condition((BytecodeNode)cursor.invoke("advanceNextPosition", Boolean.TYPE, new BytecodeExpression[0])).ifFalse((BytecodeNode)new BytecodeBlock().putVariable(finishedVariable, true).gotoLabel(done))).comment("do the projection").append((BytecodeNode)CursorProcessorCompiler.createProjectIfStatement(classDefinition, method, session, cursor, pageBuilder, projections)).comment("completedPositions++;").incrementVariable(completedPositionsVariable, (byte)1));
        method.getBody().append((BytecodeNode)whileLoop).visitLabel(done).append((BytecodeNode)BytecodeExpressions.newInstance(CursorProcessorOutput.class, (BytecodeExpression[])new BytecodeExpression[]{completedPositionsVariable, finishedVariable}).ret());
    }

    private static IfStatement createProjectIfStatement(ClassDefinition classDefinition, MethodDefinition method, Parameter session, Parameter cursor, Parameter pageBuilder, int projections) {
        IfStatement ifStatement = new IfStatement();
        ifStatement.condition().append((BytecodeNode)method.getThis()).getVariable((Variable)session).getVariable((Variable)cursor).invokeVirtual(classDefinition.getType(), "filter", ParameterizedType.type(Boolean.TYPE), new ParameterizedType[]{ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class)});
        ifStatement.ifTrue().getVariable((Variable)pageBuilder).invokeVirtual(PageBuilder.class, "declarePosition", Void.TYPE, new Class[0]);
        for (int projectionIndex = 0; projectionIndex < projections; ++projectionIndex) {
            ifStatement.ifTrue().append((BytecodeNode)method.getThis()).getVariable((Variable)session).getVariable((Variable)cursor);
            ifStatement.ifTrue().getVariable((Variable)pageBuilder).push(projectionIndex).invokeVirtual(PageBuilder.class, "getBlockBuilder", BlockBuilder.class, new Class[]{Integer.TYPE});
            ifStatement.ifTrue().invokeVirtual(classDefinition.getType(), "project_" + projectionIndex, ParameterizedType.type(Void.TYPE), new ParameterizedType[]{ParameterizedType.type(ConnectorSession.class), ParameterizedType.type(RecordCursor.class), ParameterizedType.type(BlockBuilder.class)});
        }
        return ifStatement;
    }

    private Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> generateMethodsForLambda(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression projection, String methodPrefix) {
        ImmutableSet lambdaExpressions = ImmutableSet.copyOf(LambdaExpressionExtractor.extractLambdaExpressions(projection));
        ImmutableMap.Builder compiledLambdaMap = ImmutableMap.builder();
        int counter = 0;
        for (LambdaDefinitionExpression lambdaExpression : lambdaExpressions) {
            String methodName = methodPrefix + "_lambda_" + counter;
            LambdaBytecodeGenerator.CompiledLambda compiledLambda = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, methodName, containerClassDefinition, (Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>)compiledLambdaMap.build(), callSiteBinder, cachedInstanceBinder, this.metadata);
            compiledLambdaMap.put((Object)lambdaExpression, (Object)compiledLambda);
            ++counter;
        }
        return compiledLambdaMap.build();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, RowExpression filter) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), new Parameter[]{session, cursor});
        method.comment("Filter: %s", new Object[]{filter});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.metadata, compiledLambdaMap);
        LabelNode end = new LabelNode("end");
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).comment("evaluate filter: " + filter).append(compiler.compile(filter, scope)).comment("if (wasNull) return false;").getVariable(wasNullVariable).ifFalseGoto(end).pop(Boolean.TYPE).push(false).visitLabel(end).retBoolean();
    }

    private void generateProjectMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap, String methodName, RowExpression projection) {
        Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
        Parameter cursor = Parameter.arg((String)"cursor", RecordCursor.class);
        Parameter output = Parameter.arg((String)"output", BlockBuilder.class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type(Void.TYPE), new Parameter[]{session, cursor, output});
        method.comment("Projection: %s", new Object[]{projection.toString()});
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable(ParameterizedType.type(Boolean.TYPE), "wasNull");
        RowExpressionCompiler compiler = new RowExpressionCompiler(callSiteBinder, cachedInstanceBinder, CursorProcessorCompiler.fieldReferenceCompiler((Variable)cursor), this.metadata, compiledLambdaMap);
        method.getBody().comment("boolean wasNull = false;").putVariable(wasNullVariable, false).getVariable((Variable)output).comment("evaluate projection: " + projection.toString()).append(compiler.compile(projection, scope)).append(BytecodeUtils.generateWrite(callSiteBinder, scope, wasNullVariable, projection.getType())).ret();
    }

    private static RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler(final Variable cursorVariable) {
        return new RowExpressionVisitor<BytecodeNode, Scope>(){

            @Override
            public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
                int field = node.getField();
                Type type = node.getType();
                Variable wasNullVariable = scope.getVariable("wasNull");
                Class javaType = type.getJavaType();
                IfStatement ifStatement = new IfStatement();
                ifStatement.condition().setDescription(String.format("cursor.get%s(%d)", type, field)).getVariable(cursorVariable).push(field).invokeInterface(RecordCursor.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE});
                ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
                ifStatement.ifFalse().getVariable(cursorVariable).push(field);
                if (javaType == Boolean.TYPE) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getBoolean", Boolean.TYPE, new Class[]{Integer.TYPE});
                } else if (javaType == Long.TYPE) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getLong", Long.TYPE, new Class[]{Integer.TYPE});
                } else if (javaType == Double.TYPE) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getDouble", Double.TYPE, new Class[]{Integer.TYPE});
                } else if (javaType == Slice.class) {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getSlice", Slice.class, new Class[]{Integer.TYPE});
                } else {
                    ifStatement.ifFalse().invokeInterface(RecordCursor.class, "getObject", Object.class, new Class[]{Integer.TYPE}).checkCast(javaType);
                }
                return ifStatement;
            }

            @Override
            public BytecodeNode visitCall(CallExpression call, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitSpecialForm(SpecialForm specialForm, Scope context) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
                throw new UnsupportedOperationException("not yet implemented");
            }

            @Override
            public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

