/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.MethodGenerationContext;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.trino.metadata.FunctionInvoker;
import io.trino.metadata.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.sql.gen.BytecodeUtils;
import io.trino.sql.gen.CachedInstanceBinder;
import io.trino.sql.gen.CallSiteBinder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class InvokeFunctionBytecodeExpression
extends BytecodeExpression {
    private final BytecodeNode invocation;
    private final String oneLineDescription;

    public static BytecodeExpression invokeFunction(Scope scope, CachedInstanceBinder cachedInstanceBinder, Type type, FunctionMetadata functionMetadata, Function<InvocationConvention, FunctionInvoker> functionInvokerProvider, BytecodeExpression ... parameters) {
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(functionMetadata, "functionMetadata is null");
        Objects.requireNonNull(functionInvokerProvider, "functionInvokerProvider is null");
        return new InvokeFunctionBytecodeExpression(scope, cachedInstanceBinder.getCallSiteBinder(), type, functionMetadata, functionInvokerProvider, (List<BytecodeExpression>)ImmutableList.copyOf((Object[])parameters));
    }

    private InvokeFunctionBytecodeExpression(Scope scope, CallSiteBinder binder, Type type, FunctionMetadata functionMetadata, Function<InvocationConvention, FunctionInvoker> functionInvokerProvider, List<BytecodeExpression> parameters) {
        super(ParameterizedType.type((Class)Primitives.unwrap((Class)type.getJavaType())));
        this.invocation = BytecodeUtils.generateInvocation(scope, functionMetadata, functionInvokerProvider, (List<BytecodeNode>)((List)parameters.stream().map(BytecodeNode.class::cast).collect(ImmutableList.toImmutableList())), binder);
        this.oneLineDescription = functionMetadata.getSignature().getName() + "(" + Joiner.on((String)", ").join(parameters) + ")";
    }

    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return this.invocation;
    }

    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    protected String formatOneLine() {
        return this.oneLineDescription;
    }
}

