/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import io.airlift.bytecode.DynamicClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class IsolatedClass {
    private IsolatedClass() {
    }

    public static <T> Class<? extends T> isolateClass(DynamicClassLoader dynamicClassLoader, Class<T> publicBaseClass, Class<? extends T> implementationClass, Class<?> ... additionalClasses) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)implementationClass.getName(), (Object)IsolatedClass.getBytecode(implementationClass));
        for (Class<?> additionalClass : additionalClasses) {
            builder.put((Object)additionalClass.getName(), (Object)IsolatedClass.getBytecode(additionalClass));
        }
        Map isolatedClasses = dynamicClassLoader.defineClasses((Map)builder.build());
        Class isolatedClass = (Class)isolatedClasses.get(implementationClass.getName());
        Preconditions.checkArgument((isolatedClass != null ? 1 : 0) != 0, (String)"Could load class %s", (Object)implementationClass.getName());
        Preconditions.checkArgument((boolean)publicBaseClass.isAssignableFrom(isolatedClass), (String)"Error isolating class %s, newly loaded class is not a sub type of %s", (Object)implementationClass.getName(), (Object)publicBaseClass.getName());
        Preconditions.checkState((isolatedClass != implementationClass ? 1 : 0) != 0, (Object)"Isolation failed");
        return isolatedClass.asSubclass(publicBaseClass);
    }

    private static byte[] getBytecode(Class<?> clazz) {
        byte[] byArray;
        block8: {
            InputStream stream = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
            try {
                Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (String)"Could not obtain byte code for class %s", (Object)clazz.getName());
                byArray = ByteStreams.toByteArray((InputStream)stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Could not obtain byte code for class %s", clazz.getName()), e);
                }
            }
            stream.close();
        }
        return byArray;
    }
}

