/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.RelationPlan;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TranslationMap;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.NodeRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

class PlanBuilder {
    private final TranslationMap translations;
    private final PlanNode root;

    public PlanBuilder(TranslationMap translations, PlanNode root) {
        Objects.requireNonNull(translations, "translations is null");
        Objects.requireNonNull(root, "root is null");
        this.translations = translations;
        this.root = root;
    }

    public static PlanBuilder newPlanBuilder(RelationPlan plan, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments) {
        return PlanBuilder.newPlanBuilder(plan, analysis, lambdaArguments, (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of());
    }

    public static PlanBuilder newPlanBuilder(RelationPlan plan, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, Map<ScopeAware<Expression>, Symbol> mappings) {
        return new PlanBuilder(new TranslationMap(plan.getOuterContext(), plan.getScope(), analysis, lambdaArguments, plan.getFieldMappings(), mappings), plan.getRoot());
    }

    public PlanBuilder withNewRoot(PlanNode root) {
        return new PlanBuilder(this.translations, root);
    }

    public PlanBuilder withScope(Scope scope, List<Symbol> fields) {
        return new PlanBuilder(this.translations.withScope(scope, fields), this.root);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public boolean canTranslate(Expression expression) {
        return this.translations.canTranslate(expression);
    }

    public Symbol translate(Expression expression) {
        return Symbol.from(this.translations.rewrite(expression));
    }

    public Expression rewrite(Expression expression) {
        return this.translations.rewrite(expression);
    }

    public TranslationMap getTranslations() {
        return this.translations;
    }

    public Scope getScope() {
        return this.translations.getScope();
    }

    public PlanBuilder appendProjections(Iterable<Expression> expressions, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return this.appendProjections(expressions, symbolAllocator, idAllocator, TranslationMap::rewrite, TranslationMap::canTranslate);
    }

    public <T extends Expression> PlanBuilder appendProjections(Iterable<T> expressions, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, BiFunction<TranslationMap, T, Expression> rewriter, BiPredicate<TranslationMap, T> alreadyHasTranslation) {
        Assignments.Builder projections = Assignments.builder();
        projections.putIdentities(this.root.getOutputSymbols());
        HashMap<ScopeAware<Expression>, Symbol> mappings = new HashMap<ScopeAware<Expression>, Symbol>();
        for (Expression expression : expressions) {
            if (mappings.containsKey(ScopeAware.scopeAwareKey(expression, this.translations.getAnalysis(), this.translations.getScope())) || alreadyHasTranslation.test(this.translations, (TranslationMap)expression)) continue;
            Symbol symbol = symbolAllocator.newSymbol(expression, this.translations.getAnalysis().getType(expression));
            projections.put(symbol, rewriter.apply(this.translations, (TranslationMap)expression));
            mappings.put(ScopeAware.scopeAwareKey(expression, this.translations.getAnalysis(), this.translations.getScope()), symbol);
        }
        return new PlanBuilder(this.getTranslations().withAdditionalMappings(mappings), new ProjectNode(idAllocator.getNextId(), this.root, projections.build()));
    }
}

