/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.util.AstUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class TranslationMap {
    private final Scope scope;
    private final Analysis analysis;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments;
    private final Optional<TranslationMap> outerContext;
    private final Symbol[] fieldSymbols;
    private final Map<ScopeAware<Expression>, Symbol> astToSymbols;

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols) {
        this(outerContext, scope, analysis, lambdaArguments, (Symbol[])fieldSymbols.toArray(new Symbol[0]).clone(), (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of());
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Map<ScopeAware<Expression>, Symbol> astToSymbols) {
        this(outerContext, scope, analysis, lambdaArguments, fieldSymbols.toArray(new Symbol[0]), astToSymbols);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, Symbol[] fieldSymbols, Map<ScopeAware<Expression>, Symbol> astToSymbols) {
        this.outerContext = Objects.requireNonNull(outerContext, "outerContext is null");
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.lambdaArguments = Objects.requireNonNull(lambdaArguments, "lambdaArguments is null");
        Objects.requireNonNull(fieldSymbols, "fieldSymbols is null");
        this.fieldSymbols = (Symbol[])fieldSymbols.clone();
        Objects.requireNonNull(astToSymbols, "astToSymbols is null");
        this.astToSymbols = ImmutableMap.copyOf(astToSymbols);
        Preconditions.checkArgument((scope.getLocalScopeFieldCount() == fieldSymbols.length ? 1 : 0) != 0, (String)"scope: %s, fields mappings: %s", (int)scope.getRelationType().getAllFieldCount(), (int)fieldSymbols.length);
        astToSymbols.keySet().stream().map(ScopeAware::getNode).forEach(TranslationMap::verifyAstExpression);
    }

    public TranslationMap withScope(Scope scope, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, scope, this.analysis, this.lambdaArguments, fields.toArray(new Symbol[0]), this.astToSymbols);
    }

    public TranslationMap withNewMappings(Map<ScopeAware<Expression>, Symbol> mappings, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, fields, mappings);
    }

    public TranslationMap withAdditionalMappings(Map<ScopeAware<Expression>, Symbol> mappings) {
        HashMap<ScopeAware<Expression>, Symbol> newMappings = new HashMap<ScopeAware<Expression>, Symbol>();
        newMappings.putAll(this.astToSymbols);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, this.fieldSymbols, newMappings);
    }

    public List<Symbol> getFieldSymbols() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldSymbols));
    }

    public Map<ScopeAware<Expression>, Symbol> getMappings() {
        return this.astToSymbols;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public boolean canTranslate(Expression expression) {
        TranslationMap.verifyAstExpression(expression);
        if (this.astToSymbols.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope)) || expression instanceof FieldReference) {
            return true;
        }
        if (this.analysis.isColumnReference(expression)) {
            ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
            return this.scope.isLocalScope(field.getScope());
        }
        return false;
    }

    public Expression rewrite(final Expression expression) {
        TranslationMap.verifyAstExpression(expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<Expression> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary(node, mapped.get());
                }
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                return this.coerceIfNecessary(node, rewrittenExpression);
            }

            public Expression rewriteFieldReference(FieldReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<Expression> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, mapped.get());
                }
                return (Expression)TranslationMap.this.getSymbolForColumn((Expression)node).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No symbol mapping for node '%s' (%s)", node, node.getFieldIndex())));
            }

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<Expression> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, mapped.get());
                }
                LambdaArgumentDeclaration referencedLambdaArgumentDeclaration = TranslationMap.this.analysis.getLambdaArgumentReference(node);
                if (referencedLambdaArgumentDeclaration != null) {
                    Symbol symbol2 = TranslationMap.this.lambdaArguments.get(NodeRef.of((Node)referencedLambdaArgumentDeclaration));
                    return this.coerceIfNecessary((Expression)node, (Expression)symbol2.toSymbolReference());
                }
                return TranslationMap.this.getSymbolForColumn((Expression)node).map(symbol -> this.coerceIfNecessary((Expression)node, (Expression)symbol.toSymbolReference())).orElse(this.coerceIfNecessary((Expression)node, (Expression)node));
            }

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (TranslationMap.this.analysis.isPatternRecognitionFunction(node)) {
                    List rewrittenArguments = (List)node.getArguments().stream().map(argument -> treeRewriter.rewrite(argument, null)).collect(ImmutableList.toImmutableList());
                    return this.coerceIfNecessary((Expression)node, (Expression)new FunctionCall(Optional.empty(), node.getName(), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), node.getProcessingMode(), rewrittenArguments));
                }
                Optional<Expression> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction(node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                rewritten = new FunctionCall(rewritten.getLocation(), resolvedFunction.toQualifiedName(), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getProcessingMode(), rewritten.getArguments());
                return this.coerceIfNecessary((Expression)node, (Expression)rewritten);
            }

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                ExpressionAnalyzer.LabelPrefixedReference labelDereference = TranslationMap.this.analysis.getLabelDereference(node);
                if (labelDereference != null) {
                    Expression rewritten = treeRewriter.rewrite((Expression)labelDereference.getColumn(), null);
                    Preconditions.checkState((boolean)(rewritten instanceof SymbolReference), (Object)("expected symbol reference, got: " + rewritten));
                    return this.coerceIfNecessary((Expression)node, (Expression)new LabelDereference(labelDereference.getLabel(), (SymbolReference)rewritten));
                }
                Optional<Expression> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, mapped.get());
                }
                if (TranslationMap.this.analysis.isColumnReference((Expression)node)) {
                    return this.coerceIfNecessary((Expression)node, (Expression)TranslationMap.this.getSymbolForColumn((Expression)node).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No mapping for %s", node))));
                }
                return this.rewriteExpression((Expression)node, context, treeRewriter);
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Preconditions.checkState((TranslationMap.this.analysis.getCoercion((Expression)node) == null ? 1 : 0) != 0, (Object)"cannot coerce a lambda expression");
                ImmutableList.Builder newArguments = ImmutableList.builder();
                for (LambdaArgumentDeclaration argument : node.getArguments()) {
                    Symbol symbol = TranslationMap.this.lambdaArguments.get(NodeRef.of((Node)argument));
                    newArguments.add((Object)new LambdaArgumentDeclaration(new Identifier(symbol.getName())));
                }
                Expression rewrittenBody = treeRewriter.rewrite(node.getBody(), null);
                return new LambdaExpression((List)newArguments.build(), rewrittenBody);
            }

            public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<Expression> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, mapped.get());
                }
                Preconditions.checkState((TranslationMap.this.analysis.getParameters().size() > node.getPosition() ? 1 : 0) != 0, (Object)"Too few parameter values");
                return this.coerceIfNecessary((Expression)node, treeRewriter.rewrite(TranslationMap.this.analysis.getParameters().get(NodeRef.of((Node)node)), null));
            }

            public Expression rewriteGenericDataType(GenericDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            public Expression rewriteRowDataType(RowDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            private Expression coerceIfNecessary(Expression original, Expression rewritten) {
                if (original == expression) {
                    return rewritten;
                }
                return QueryPlanner.coerceIfNecessary(TranslationMap.this.analysis, original, rewritten);
            }
        }, (Expression)expression, null);
    }

    private Optional<Expression> tryGetMapping(Expression expression) {
        return Optional.ofNullable(this.astToSymbols.get(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope))).map(Symbol::toSymbolReference);
    }

    private Optional<Symbol> getSymbolForColumn(Expression expression) {
        if (!this.analysis.isColumnReference(expression)) {
            return Optional.empty();
        }
        ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
        if (this.scope.isLocalScope(field.getScope())) {
            return Optional.of(this.fieldSymbols[field.getHierarchyFieldIndex()]);
        }
        return Optional.of(Symbol.from(this.outerContext.get().rewrite(expression)));
    }

    private static void verifyAstExpression(Expression astExpression) {
        Verify.verify((boolean)AstUtils.preOrder((Node)astExpression).noneMatch(expression -> expression instanceof SymbolReference || expression instanceof FunctionCall && ResolvedFunction.isResolved(((FunctionCall)expression).getName())));
    }

    public Scope getScope() {
        return this.scope;
    }
}

