/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class CanonicalizeExpressionRewriter {
    public static Expression canonicalizeExpression(Expression expression, Map<NodeRef<Expression>, Type> expressionTypes, Metadata metadata) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private CanonicalizeExpressionRewriter() {
    }

    public static Expression rewrite(Expression expression, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, types, expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(metadata, expressionTypes), (Expression)expression);
    }

    private static boolean isConstant(Expression expression) {
        if (expression instanceof Cast && ((Cast)expression).getExpression() instanceof Literal) {
            return true;
        }
        return expression instanceof Literal;
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private final Metadata metadata;
        private final Map<NodeRef<Expression>, Type> expressionTypes;

        public Visitor(Metadata metadata, Map<NodeRef<Expression>, Type> expressionTypes) {
            this.metadata = metadata;
            this.expressionTypes = expressionTypes;
        }

        public Expression rewriteComparisonExpression(ComparisonExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (CanonicalizeExpressionRewriter.isConstant(node.getLeft()) && !CanonicalizeExpressionRewriter.isConstant(node.getRight())) {
                node = new ComparisonExpression(node.getOperator().flip(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteArithmeticBinary(ArithmeticBinaryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if ((node.getOperator() == ArithmeticBinaryExpression.Operator.MULTIPLY || node.getOperator() == ArithmeticBinaryExpression.Operator.ADD) && CanonicalizeExpressionRewriter.isConstant(node.getLeft()) && !CanonicalizeExpressionRewriter.isConstant(node.getRight())) {
                node = new ArithmeticBinaryExpression(node.getOperator(), node.getRight(), node.getLeft());
            }
            return treeRewriter.defaultRewrite((Expression)node, (Object)context);
        }

        public Expression rewriteIsNotNullPredicate(IsNotNullPredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
            return new NotExpression((Expression)new IsNullPredicate(value));
        }

        public Expression rewriteIfExpression(IfExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression condition = treeRewriter.rewrite(node.getCondition(), (Object)context);
            Expression trueValue = treeRewriter.rewrite(node.getTrueValue(), (Object)context);
            Optional<Expression> falseValue = node.getFalseValue().map(value -> treeRewriter.rewrite(value, (Object)context));
            return new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause(condition, trueValue)), falseValue);
        }

        public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            switch (node.getFunction()) {
                case DATE: {
                    Preconditions.checkArgument((node.getPrecision() == null ? 1 : 0) != 0);
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"current_date")).build();
                }
                case TIME: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$current_time")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                }
                case LOCALTIME: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$localtime")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                }
                case TIMESTAMP: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$current_timestamp")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                }
                case LOCALTIMESTAMP: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$localtimestamp")).setArguments((List<Type>)ImmutableList.of((Object)this.expressionTypes.get(NodeRef.of((Node)node))), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getFunction());
        }

        public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
            Type type = this.expressionTypes.get(NodeRef.of((Node)node.getExpression()));
            switch (node.getField()) {
                case YEAR: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"year")).addArgument(type, value).build();
                }
                case QUARTER: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"quarter")).addArgument(type, value).build();
                }
                case MONTH: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"month")).addArgument(type, value).build();
                }
                case WEEK: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"week")).addArgument(type, value).build();
                }
                case DAY: 
                case DAY_OF_MONTH: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"day")).addArgument(type, value).build();
                }
                case DAY_OF_WEEK: 
                case DOW: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"day_of_week")).addArgument(type, value).build();
                }
                case DAY_OF_YEAR: 
                case DOY: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"day_of_year")).addArgument(type, value).build();
                }
                case YEAR_OF_WEEK: 
                case YOW: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"year_of_week")).addArgument(type, value).build();
                }
                case HOUR: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"hour")).addArgument(type, value).build();
                }
                case MINUTE: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"minute")).addArgument(type, value).build();
                }
                case SECOND: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"second")).addArgument(type, value).build();
                }
                case TIMEZONE_MINUTE: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"timezone_minute")).addArgument(type, value).build();
                }
                case TIMEZONE_HOUR: {
                    return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"timezone_hour")).addArgument(type, value).build();
                }
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getField());
        }

        public Expression rewriteFormat(Format node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List arguments = (List)node.getArguments().stream().map(value -> treeRewriter.rewrite(value, (Object)context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)node.getArguments().stream().map(NodeRef::of).map(this.expressionTypes::get).collect(ImmutableList.toImmutableList());
            return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"$format")).addArgument((Type)VarcharType.VARCHAR, (Expression)arguments.get(0)).addArgument((Type)RowType.anonymous(argumentTypes.subList(1, arguments.size())), (Expression)new Row(arguments.subList(1, arguments.size()))).build();
        }
    }
}

