/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TopNNode;

public class CreatePartialTopN
implements Rule<TopNNode> {
    private static final Pattern<TopNNode> PATTERN = Patterns.topN().with(Patterns.TopN.step().equalTo((Object)TopNNode.Step.SINGLE));

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode single, Captures captures, Rule.Context context) {
        TopNNode partial = new TopNNode(context.getIdAllocator().getNextId(), single.getSource(), single.getCount(), single.getOrderingScheme(), TopNNode.Step.PARTIAL);
        return Rule.Result.ofPlanNode(new TopNNode(context.getIdAllocator().getNextId(), partial, single.getCount(), single.getOrderingScheme(), TopNNode.Step.FINAL));
    }
}

