/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SetOperationNodeTranslator;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import java.util.List;
import java.util.Objects;

public class ImplementExceptAll
implements Rule<ExceptNode> {
    private static final Pattern<ExceptNode> PATTERN = Patterns.except().with(Patterns.Except.distinct().equalTo((Object)false));
    private final Metadata metadata;

    public ImplementExceptAll(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<ExceptNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExceptNode node, Captures captures, Rule.Context context) {
        SetOperationNodeTranslator translator = new SetOperationNodeTranslator(this.metadata, context.getSymbolAllocator(), context.getIdAllocator());
        SetOperationNodeTranslator.TranslationResult result = translator.makeSetContainmentPlanForAll(node);
        Preconditions.checkState((result.getCountSymbols().size() > 0 ? 1 : 0) != 0, (Object)"ExceptNode translation result has no count symbols");
        ResolvedFunction greatest = this.metadata.resolveFunction(QualifiedName.of((String)"greatest"), TypeSignatureProvider.fromTypes(new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
        SymbolReference count = result.getCountSymbols().get(0).toSymbolReference();
        for (int i = 1; i < result.getCountSymbols().size(); ++i) {
            count = new FunctionCall(greatest.toQualifiedName(), (List)ImmutableList.of((Object)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)count, (Expression)result.getCountSymbols().get(i).toSymbolReference()), (Object)new GenericLiteral("BIGINT", "0")));
        }
        ComparisonExpression removeExtraRows = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)result.getRowNumberSymbol().toSymbolReference(), (Expression)count);
        FilterNode filter = new FilterNode(context.getIdAllocator().getNextId(), result.getPlanNode(), (Expression)removeExtraRows);
        ProjectNode project = new ProjectNode(context.getIdAllocator().getNextId(), filter, Assignments.identity(node.getOutputSymbols()));
        return Rule.Result.ofPlanNode(project);
    }
}

