/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;

public class MergeLimits
implements Rule<LimitNode> {
    private static final Capture<LimitNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies()).with(Patterns.source().matching(Patterns.limit().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        LimitNode child = (LimitNode)captures.get(CHILD);
        if (!child.isWithTies()) {
            return Rule.Result.ofPlanNode(new LimitNode(parent.getId(), child.getSource(), Math.min(parent.getCount(), child.getCount()), parent.getTiesResolvingScheme(), parent.isPartial()));
        }
        if (parent.getCount() > child.getCount()) {
            return Rule.Result.ofPlanNode(child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)child.getSource())))));
        }
        return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)child.getSource())));
    }
}

