/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PushDownDereferenceThroughProject
implements Rule<ProjectNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private final TypeAnalyzer typeAnalyzer;

    public PushDownDereferenceThroughProject(TypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        Set dereferences = DereferencePushdown.extractDereferences(node.getAssignments().getExpressions(), false);
        if ((dereferences = (Set)dereferences.stream().filter(expression -> child.getSource().getOutputSymbols().contains(DereferencePushdown.getBase(expression))).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments assignments = node.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new ProjectNode(context.getIdAllocator().getNextId(), child.getSource(), Assignments.builder().putAll(child.getAssignments()).putAll(dereferenceAssignments).build()), assignments));
    }
}

