/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.ExpressionNodeInliner;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DereferencePushdown;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PushDownDereferencesThroughWindow
implements Rule<ProjectNode> {
    private static final Capture<WindowNode> CHILD = Capture.newCapture();
    private final TypeAnalyzer typeAnalyzer;

    public PushDownDereferencesThroughWindow(TypeAnalyzer typeAnalyzer) {
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(Patterns.window().capturedAs(CHILD)));
    }

    @Override
    public Rule.Result apply(ProjectNode projectNode, Captures captures, Rule.Context context) {
        WindowNode windowNode = (WindowNode)captures.get(CHILD);
        Set dereferences = DereferencePushdown.extractDereferences((Collection<Expression>)ImmutableList.builder().addAll(projectNode.getAssignments().getExpressions()).addAll((Iterable)windowNode.getWindowFunctions().values().stream().flatMap(function -> function.getArguments().stream()).collect(ImmutableList.toImmutableList())).build(), false);
        WindowNode.Specification specification = windowNode.getSpecification();
        if ((dereferences = (Set)dereferences.stream().filter(expression -> {
            Symbol symbol = DereferencePushdown.getBase(expression);
            return !specification.getPartitionBy().contains(symbol) && !specification.getOrderingScheme().map(OrderingScheme::getOrderBy).orElse((List)ImmutableList.of()).contains(symbol) && !windowNode.getCreatedSymbols().contains(symbol);
        }).collect(ImmutableSet.toImmutableSet())).isEmpty()) {
            return Rule.Result.empty();
        }
        Assignments dereferenceAssignments = Assignments.of(dereferences, context.getSession(), context.getSymbolAllocator(), this.typeAnalyzer);
        Map mappings = (Map)HashBiMap.create(dereferenceAssignments.getMap()).inverse().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
        Assignments newAssignments = projectNode.getAssignments().rewrite(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), new WindowNode(windowNode.getId(), new ProjectNode(context.getIdAllocator().getNextId(), windowNode.getSource(), Assignments.builder().putIdentities(windowNode.getSource().getOutputSymbols()).putAll(dereferenceAssignments).build()), windowNode.getSpecification(), (Map)windowNode.getWindowFunctions().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            WindowNode.Function oldFunction = (WindowNode.Function)entry.getValue();
            return new WindowNode.Function(oldFunction.getResolvedFunction(), (List)oldFunction.getArguments().stream().map(expression -> ExpressionNodeInliner.replaceExpression(expression, mappings)).collect(ImmutableList.toImmutableList()), oldFunction.getFrame(), oldFunction.isIgnoreNulls());
        })), windowNode.getHashSymbol(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix()), newAssignments));
    }
}

