/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Optional;

public class PushLimitIntoTableScan
implements Rule<LimitNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies()).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;

    public PushLimitIntoTableScan(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(LimitNode limit, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        return this.metadata.applyLimit(context.getSession(), tableScan.getTable(), limit.getCount()).map(result -> {
            PlanNode node = new TableScanNode(tableScan.getId(), (TableHandle)result.getHandle(), tableScan.getOutputSymbols(), tableScan.getAssignments(), tableScan.getEnforcedConstraint(), tableScan.isUpdateTarget(), Optional.empty());
            if (!result.isLimitGuaranteed()) {
                node = new LimitNode(limit.getId(), node, limit.getCount(), limit.isPartial());
            }
            return Rule.Result.ofPlanNode(node);
        }).orElseGet(Rule.Result::empty);
    }
}

