/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.PartialTranslator;
import io.trino.sql.planner.ReferenceAwareExpressionNodeInliner;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.NodeRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PushProjectionIntoTableScan
implements Rule<ProjectNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;
    private final TypeAnalyzer typeAnalyzer;

    public PushProjectionIntoTableScan(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        this.metadata = metadata;
        this.typeAnalyzer = typeAnalyzer;
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Map<Symbol, Expression> inputExpressions = project.getAssignments().getMap();
        ImmutableList.Builder nodeReferencesBuilder = ImmutableList.builder();
        ImmutableList.Builder partialProjectionsBuilder = ImmutableList.builder();
        for (Map.Entry<Symbol, Expression> expression2 : inputExpressions.entrySet()) {
            Map<NodeRef<Expression>, ConnectorExpression> partialTranslations = PartialTranslator.extractPartialTranslations(expression2.getValue(), context.getSession(), this.typeAnalyzer, context.getSymbolAllocator().getTypes());
            partialTranslations.forEach((nodeRef, expr) -> {
                nodeReferencesBuilder.add(nodeRef);
                partialProjectionsBuilder.add(expr);
            });
        }
        ImmutableList nodesForPartialProjections = nodeReferencesBuilder.build();
        ImmutableList connectorPartialProjections = partialProjectionsBuilder.build();
        Map assignments = (Map)tableScan.getAssignments().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((Symbol)entry.getKey()).getName(), Map.Entry::getValue));
        Optional<ProjectionApplicationResult<TableHandle>> result = this.metadata.applyProjection(context.getSession(), tableScan.getTable(), (List<ConnectorExpression>)connectorPartialProjections, assignments);
        if (result.isEmpty()) {
            return Rule.Result.empty();
        }
        List newConnectorPartialProjections = result.get().getProjections();
        Preconditions.checkState((newConnectorPartialProjections.size() == connectorPartialProjections.size() ? 1 : 0) != 0, (String)"Mismatch between input and output projections from the connector: expected %s but got %s", (int)connectorPartialProjections.size(), (int)newConnectorPartialProjections.size());
        ArrayList<Symbol> newScanOutputs = new ArrayList<Symbol>();
        HashMap<Symbol, ColumnHandle> newScanAssignments = new HashMap<Symbol, ColumnHandle>();
        HashMap<String, Symbol> variableMappings = new HashMap<String, Symbol>();
        for (Assignment assignment : result.get().getAssignments()) {
            Symbol symbol = context.getSymbolAllocator().newSymbol(assignment.getVariable(), assignment.getType());
            newScanOutputs.add(symbol);
            newScanAssignments.put(symbol, assignment.getColumn());
            variableMappings.put(assignment.getVariable(), symbol);
        }
        List newPartialProjections = (List)newConnectorPartialProjections.stream().map(expression -> ConnectorExpressionTranslator.translate(expression, variableMappings, new LiteralEncoder(this.metadata))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder nodesToNewPartialProjectionsBuilder = ImmutableMap.builder();
        for (int i = 0; i < nodesForPartialProjections.size(); ++i) {
            nodesToNewPartialProjectionsBuilder.put((Object)((NodeRef)nodesForPartialProjections.get(i)), (Object)((Expression)newPartialProjections.get(i)));
        }
        ImmutableMap nodesToNewPartialProjections = nodesToNewPartialProjectionsBuilder.build();
        Assignments.Builder newProjectionAssignments = Assignments.builder();
        project.getAssignments().entrySet().forEach(arg_0 -> PushProjectionIntoTableScan.lambda$apply$3(newProjectionAssignments, (Map)nodesToNewPartialProjections, arg_0));
        this.verifyTablePartitioning(context, tableScan, (TableHandle)result.get().getHandle());
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), TableScanNode.newInstance(tableScan.getId(), (TableHandle)result.get().getHandle(), newScanOutputs, newScanAssignments, tableScan.isUpdateTarget(), tableScan.getUseConnectorNodePartitioning()), newProjectionAssignments.build()));
    }

    private void verifyTablePartitioning(Rule.Context context, TableScanNode oldTableScan, TableHandle newTable) {
        if (oldTableScan.getUseConnectorNodePartitioning().isEmpty()) {
            return;
        }
        Optional<TableProperties.TablePartitioning> oldTablePartitioning = this.metadata.getTableProperties(context.getSession(), oldTableScan.getTable()).getTablePartitioning();
        Optional<TableProperties.TablePartitioning> newTablePartitioning = this.metadata.getTableProperties(context.getSession(), newTable).getTablePartitioning();
        Verify.verify((boolean)newTablePartitioning.equals(oldTablePartitioning), (String)"Partitioning must not change after projection is pushed down", (Object[])new Object[0]);
    }

    private static /* synthetic */ void lambda$apply$3(Assignments.Builder newProjectionAssignments, Map nodesToNewPartialProjections, Map.Entry entry) {
        newProjectionAssignments.put((Symbol)entry.getKey(), ReferenceAwareExpressionNodeInliner.replaceExpression((Expression)entry.getValue(), nodesToNewPartialProjections));
    }
}

