/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.type.Type;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.NoOpSymbolResolver;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ExpressionRewriteRuleSet;
import io.trino.sql.planner.iterative.rule.ExtractCommonPredicatesExpressionRewriter;
import io.trino.sql.planner.iterative.rule.PushDownNegationsExpressionRewriter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.SymbolReference;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SimplifyExpressions
extends ExpressionRewriteRuleSet {
    @VisibleForTesting
    static Expression rewrite(Expression expression, Session session, SymbolAllocator symbolAllocator, Metadata metadata, LiteralEncoder literalEncoder, TypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        if (expression instanceof SymbolReference) {
            return expression;
        }
        Map<NodeRef<Expression>, Type> expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        expression = PushDownNegationsExpressionRewriter.pushDownNegations(metadata, expression, expressionTypes);
        expression = ExtractCommonPredicatesExpressionRewriter.extractCommonPredicates(metadata, expression);
        expressionTypes = typeAnalyzer.getTypes(session, symbolAllocator.getTypes(), expression);
        ExpressionInterpreter interpreter = new ExpressionInterpreter(expression, metadata, session, expressionTypes);
        Object optimized = interpreter.optimize(NoOpSymbolResolver.INSTANCE);
        return literalEncoder.toExpression(optimized, expressionTypes.get(NodeRef.of((Node)expression)));
    }

    public SimplifyExpressions(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        super(SimplifyExpressions.createRewrite(metadata, typeAnalyzer));
    }

    @Override
    public Set<Rule<?>> rules() {
        return ImmutableSet.of(this.projectExpressionRewrite(), this.filterExpressionRewrite(), this.joinExpressionRewrite(), this.valuesExpressionRewrite());
    }

    private static ExpressionRewriteRuleSet.ExpressionRewriter createRewrite(Metadata metadata, TypeAnalyzer typeAnalyzer) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
        LiteralEncoder literalEncoder = new LiteralEncoder(metadata);
        return (expression, context) -> SimplifyExpressions.rewrite(expression, context.getSession(), context.getSymbolAllocator(), metadata, literalEncoder, typeAnalyzer);
    }
}

